# WooCommerce PIX Gateway

Plugin para WordPress WooCommerce que integra com gateway de pagamento PIX usando a API Asaas.

## 📋 Descrição

Este plugin permite que sua loja WooCommerce aceite pagamentos PIX através de um gateway integrado com o Asaas. Os clientes podem pagar usando PIX de forma rápida e segura, com confirmação automática de pagamento.

## ✨ Funcionalidades

- ✅ Integração completa com WooCommerce
- ✅ Pagamentos PIX instantâneos
- ✅ QR Code automático para pagamento
- ✅ Código PIX copiável
- ✅ Webhook para confirmação automática
- ✅ Interface responsiva e moderna
- ✅ Modo sandbox para testes
- ✅ Logs de debug detalhados
- ✅ Painel administrativo completo
- ✅ Estatísticas de pagamentos
- ✅ Suporte a múltiplos idiomas

## 🔧 Requisitos

- WordPress 5.0 ou superior
- WooCommerce 5.0 ou superior
- PHP 7.4 ou superior
- API Key do gateway PIX

## 📦 Instalação

### 1. Upload do Plugin

1. Faça o download do plugin
2. Acesse o painel administrativo do WordPress
3. Vá em **Plugins > Adicionar Novo**
4. Clique em **Enviar Plugin**
5. Selecione o arquivo ZIP do plugin
6. Clique em **Instalar Agora**
7. Após a instalação, clique em **Ativar Plugin**

### 2. Configuração

1. Vá em **WooCommerce > Configurações > Checkout**
2. Na seção **Gateways de Pagamento**, encontre **Gateway PIX**
3. Clique em **Gerenciar**
4. Configure os seguintes campos:
   - **Habilitar Gateway PIX**: Marque para ativar
   - **Título**: Nome que aparecerá no checkout
   - **Descrição**: Descrição do método de pagamento
   - **API Key**: Sua chave de API fornecida pelo gateway
   - **URL da API**: URL base da API (padrão já configurado)
   - **Modo Sandbox**: Marque para testes
   - **Modo Debug**: Marque para logs detalhados

### 3. Configurações Avançadas

1. Acesse **WooCommerce > PIX Gateway** no menu lateral
2. Configure opções adicionais como tempo de expiração
3. Teste a conexão com a API
4. Visualize estatísticas de pagamentos

## 🚀 Como Funciona

### Para o Cliente

1. **Checkout**: O cliente escolhe PIX como método de pagamento
2. **Pagamento**: É redirecionado para a página de pagamento PIX
3. **QR Code**: Escaneia o QR Code com o app bancário
4. **Confirmação**: O pagamento é confirmado automaticamente
5. **Pedido**: O pedido é processado automaticamente

### Para o Administrador

1. **Configuração**: Configura a API Key e outras opções
2. **Monitoramento**: Acompanha pagamentos em tempo real
3. **Webhooks**: Recebe notificações automáticas de mudanças de status
4. **Logs**: Acessa logs detalhados para debugging

## 🔌 Integração com API

O plugin se integra com a API do gateway através dos seguintes endpoints:

- **POST** `/criar-pagamento.php` - Cria novo pagamento PIX
- **GET** `/consultar-status.php` - Consulta status do pagamento
- **Webhook** - Recebe notificações de mudança de status

### Exemplo de Requisição

```json
{
    "amount": 100.50,
    "client": {
        "name": "João Silva",
        "document": "12345678901",
        "email": "joao@email.com",
        "telefone": "11999999999"
    },
    "api-key": "sua_api_key_aqui",
    "postback": "https://sualoja.com/wc-api/wc_pix_gateway"
}
```

## 📱 Interface do Cliente

A página de pagamento PIX inclui:

- **QR Code**: Para escaneamento rápido
- **Código PIX**: Copiável para pagamento manual
- **Instruções**: Passo a passo para pagar
- **Contador**: Tempo restante para pagamento
- **Verificação**: Botão para verificar status manualmente
- **Responsivo**: Funciona em dispositivos móveis

## 🛠️ Personalização

### CSS Personalizado

Adicione CSS personalizado ao seu tema:

```css
/* Personalizar cores do QR Code */
.pix-qr-image {
    border-color: #sua-cor;
}

/* Personalizar botões */
.copy-pix-code {
    background-color: #sua-cor;
}
```

### JavaScript Personalizado

```javascript
// Hook para eventos de pagamento
jQuery(document).on('pix_payment_created', function(event, data) {
    console.log('Pagamento PIX criado:', data);
});
```

## 🔍 Troubleshooting

### Problemas Comuns

1. **API Key inválida**
   - Verifique se a chave está correta
   - Teste a conexão na página de configurações

2. **Webhook não funcionando**
   - Verifique se a URL está acessível
   - Confirme se o SSL está configurado

3. **QR Code não aparece**
   - Verifique se a API retornou dados válidos
   - Ative o modo debug para mais informações

### Logs de Debug

1. Ative o modo debug nas configurações
2. Acesse **WooCommerce > Status > Logs**
3. Procure por logs com fonte "pix_gateway"

## 📊 Status dos Pagamentos

- **WAITING_FOR_APPROVAL**: Aguardando pagamento
- **PAID_OUT**: Pagamento confirmado
- **OVERDUE**: Pagamento vencido
- **CANCELLED**: Pagamento cancelado
- **REFUNDED**: Pagamento estornado

## 🌐 Suporte

- **Documentação**: [berapay.com.br](https://web.berapay.com.br)
- **Suporte**: suporte@seusite.com
- **Issues**: Reporte problemas no repositório

## 📝 Changelog

### Versão 1.0.0
- ✅ Integração inicial com gateway PIX
- ✅ Interface de pagamento responsiva
- ✅ Webhook para confirmação automática
- ✅ Painel administrativo completo
- ✅ Suporte a múltiplos idiomas
- ✅ Logs de debug detalhados

## 🤝 Contribuição

Contribuições são bem-vindas! Para contribuir:

1. Faça um fork do projeto
2. Crie uma branch para sua feature
3. Commit suas mudanças
4. Push para a branch
5. Abra um Pull Request

## 📄 Licença

Este plugin é licenciado sob a GPL v2 ou posterior.

## 🙏 Agradecimentos

- Equipe do WooCommerce
- Comunidade WordPress
- Usuários que testaram e reportaram bugs

---

**Desenvolvido com ❤️ para a comunidade WordPress**
