-- Tabela para armazenar integrações de anúncios por usuário
-- Execute este arquivo no seu banco de dados

CREATE TABLE IF NOT EXISTS `integracoes_ads` (
  `user_id` varchar(255) NOT NULL,
  `meta_pixel` varchar(191) DEFAULT NULL,
  `meta_token` varchar(255) DEFAULT NULL,
  `google_snippet_code` varchar(191) DEFAULT NULL,
  `google_label` varchar(191) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Caso a tabela já exista sem as colunas, adiciona-as de forma segura
ALTER TABLE `integracoes_ads` ADD COLUMN IF NOT EXISTS `meta_pixel` varchar(191) NULL;
ALTER TABLE `integracoes_ads` ADD COLUMN IF NOT EXISTS `meta_token` varchar(255) NULL;
ALTER TABLE `integracoes_ads` ADD COLUMN IF NOT EXISTS `google_snippet_code` varchar(191) NULL;
ALTER TABLE `integracoes_ads` ADD COLUMN IF NOT EXISTS `google_label` varchar(191) NULL;
ALTER TABLE `integracoes_ads` ADD COLUMN IF NOT EXISTS `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;


