<?php
session_start();
if (!isset($_SESSION['email']) || !isset($_SESSION['user_id'])) {
    header('Location: ../');
    exit;
}

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
if ($conn->connect_error) {
    die('Erro na conexão: ' . $conn->connect_error);
}

$user_id = $_SESSION['user_id'];
$meta_pixel = isset($_POST['meta_pixel']) ? trim($_POST['meta_pixel']) : '';
$meta_token = isset($_POST['meta_token']) ? trim($_POST['meta_token']) : '';

if ($meta_pixel === '' || $meta_token === '') {
    header('Location: ./?error=Campos obrigatórios');
    exit;
}

// Garante a existência de um registro por usuário (upsert)
$sql = "INSERT INTO integracoes_ads (user_id, meta_pixel, meta_token) VALUES (?, ?, ?) 
        ON DUPLICATE KEY UPDATE meta_pixel = VALUES(meta_pixel), meta_token = VALUES(meta_token)";
$stmt = $conn->prepare($sql);
$stmt->bind_param('sss', $user_id, $meta_pixel, $meta_token);
$stmt->execute();
$stmt->close();
$conn->close();

header('Location: ./?saved=meta');
exit;
?>


