<?php
// Certifique-se de que este script só pode ser acessado via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method Not Allowed']);
    exit();
}

// Obter dados do corpo da requisição JSON
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Validar dados recebidos
$pixel_id = $data['meta_pixel_id'] ?? null;
$access_token = $data['meta_access_token'] ?? null;
$event_value = $data['value'] ?? null;
$currency = $data['currency'] ?? 'BRL';
$event_name = $data['event_name'] ?? 'Purchase';
$event_source_url = $data['event_source_url'] ?? '';
$user_email = $data['user_email'] ?? '';
$client_ip_address = $_SERVER['REMOTE_ADDR'] ?? '';
$client_user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';

if (!$pixel_id || !$access_token || !$event_value) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing required parameters: meta_pixel_id, meta_access_token, value']);
    exit();
}

$url = "https://graph.facebook.com/v18.0/{$pixel_id}/events";

// Dados para enviar ao Facebook Conversions API
$facebook_event_data = [
    'data' => [
        [
            'event_name' => $event_name,
            'event_time' => time(),
            'action_source' => 'website',
            'event_source_url' => $event_source_url,
            'user_data' => [
                'client_ip_address' => hash('sha256', $client_ip_address),
                'client_user_agent' => hash('sha256', $client_user_agent),
                'em' => hash('sha256', $user_email) // Email do usuário, se disponível
            ],
            'custom_data' => [
                'currency' => $currency,
                'value' => (float) $event_value
            ]
        ]
    ],
    'access_token' => $access_token
];

$ch = curl_init($url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($facebook_event_data));
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/json",
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code == 200) {
    echo json_encode(['success' => true, 'response' => json_decode($response)]);
} else {
    echo json_encode(['success' => false, 'error' => 'Failed to send event to Meta Ads', 'details' => $response, 'http_code' => $http_code]);
}

?>
