




<?php
session_start();

// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
  // Se o e-mail não estiver presente na sessão, redirecione para outra página
  header("Location: ../");
  exit; // Certifique-se de sair do script após o redirecionamento
}

// Verificar mensagens de erro da URL
$erro = $_GET['erro'] ?? '';
$valorBloqueado = $_GET['valor'] ?? 0;

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
  die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Recuperar o e-mail da sessão
$email = $_SESSION['email'];

// Consultar o status do usuário e a taxa_cash_out pelo email
$sql = "SELECT status, taxa_cash_out FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($status, $taxa_cash_out);
$stmt->fetch();

$stmt->close();
$conn->close();

// Verificar o status do usuário
if ($status == 0) {
  // Redirecionar imediatamente para a página ../home se o status for 0
  header("Location: ../home");
  exit;
}

// Verificar o status do usuário
if ($status == 5) {
    // Redirecionar imediatamente para a página ../home se o status for 0
    header("Location: ../home");
    exit;
  }
?>






<?php
session_start();
function safe_number_format($num, $decimals = 2) {
    // Se $num for null ou não for um número válido, substitui por 0
    return number_format(is_numeric($num) ? $num : 0, $decimals);
}
// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
  // Se o e-mail não estiver presente na sessão, redirecione para outra página
  header("Location: ../");
  exit; // Certifique-se de sair do script após o redirecionamento
}

include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
  die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Recuperar o e-mail da sessão
$email = $_SESSION['email'];

$sql = "SELECT user_id, nome, status, permission, saldo, transacoes_aproved FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($user_id, $nome, $status, $permission, $saldo, $transacoes_aproved);
$stmt->fetch();

// Armazenar o user_id na sessão
$_SESSION['user_id'] = $user_id;

$stmt->close();
$conn->close();
?>




<?php

// Verifica se o parâmetro de logout foi passado na URL
if (isset($_GET['logout'])) {
    // Destroi a sessão
    session_destroy();
    // Redireciona para a página inicial
    header("Location: ../");
    exit;
}
?>





<?php

// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
  // Se o e-mail não estiver presente na sessão, redirecione para outra página
  header("Location: ../");
  exit; // Certifique-se de sair do script após o redirecionamento
}

// Incluir o arquivo de configuração do banco de dados
include '../conectarbanco.php';

// Criar uma conexão com o banco de dados usando as credenciais fornecidas
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
  die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Recuperar o e-mail da sessão
$email = $_SESSION['email'];

// Consulta SQL para obter informações do usuário com base no e-mail da sessão
$sql = "SELECT user_id, nome, status, permission, saldo, transacoes_aproved FROM users WHERE email = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($user_id, $nome, $status, $permission, $saldo, $transacoes_aproved);
$stmt->fetch();

// Armazenar user_id em uma variável
$user_id_var = $user_id;

$stmt->close();
$conn->close();
?>







<?php
// Incluir o arquivo de configuração do banco de dados
include '../conectar_api_banco.php';

// Criar a conexão usando as credenciais fornecidas no arquivo incluído
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
    die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Definir o ID do usuário (presumindo que já está definido em $user_id_var)
$user_id2 = $user_id_var;

// Atualizar a consulta SQL para buscar as últimas 4 solicitações ordenadas por ID decrescente
$sql_solicitacoes = "SELECT id, externalreference, amount, deposito_liquido, client_name, client_document, client_email, real_data, status, paymentcode 
                     FROM solicitacoes 
                     WHERE user_id = ? 
                     ORDER BY id DESC 
                     LIMIT 4";
$stmt_solicitacoes = $conn->prepare($sql_solicitacoes);
$stmt_solicitacoes->bind_param("s", $user_id2); // 's' para string
$stmt_solicitacoes->execute();
$result_solicitacoes = $stmt_solicitacoes->get_result();

// Fechar a conexão
$stmt_solicitacoes->close();
$conn->close();
?>






<?php
// Incluir o arquivo de conexão
include '../conectar_api_banco.php';

// Criar a conexão usando as credenciais fornecidas no arquivo incluído
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verificar a conexão
if ($conn->connect_error) {
    die("Conexão falhou: " . $conn->connect_error);
}


if (!isset($_SESSION['user_id'])) {
    die("User ID não encontrado na sessão.");
}


// Inicializar variáveis
$totalPaidOut = 0;
$totalRequests = 0;
$sumAmountPaidOut = 0;
$realDate = null; // Variável para a coluna real_date

// Consultar o número de linhas com status = 'PAID_OUT' para o user_id
$sqlPaidOut = "SELECT COUNT(*) AS totalPaidOut FROM solicitacoes WHERE user_id = ? AND status = 'PAID_OUT'";
$stmtPaidOut = $conn->prepare($sqlPaidOut);
$stmtPaidOut->bind_param("s", $user_id2);
$stmtPaidOut->execute();
$stmtPaidOut->bind_result($totalPaidOut);
$stmtPaidOut->fetch();
$stmtPaidOut->close();

// Consultar o número total de linhas para o user_id
$sqlTotalRequests = "SELECT COUNT(*) AS totalRequests FROM solicitacoes WHERE user_id = ?";
$stmtTotalRequests = $conn->prepare($sqlTotalRequests);
$stmtTotalRequests->bind_param("s", $user_id2);
$stmtTotalRequests->execute();
$stmtTotalRequests->bind_result($totalRequests);
$stmtTotalRequests->fetch();
$stmtTotalRequests->close();


// Consultar a soma dos valores na coluna amount para as linhas com status = 'PAID_OUT' e user_id correspondente
$sqlSumAmountPaidOut = "SELECT SUM(amount) AS sumAmountPaidOut FROM solicitacoes WHERE user_id = ? AND status = 'PAID_OUT'";
$stmtSumAmountPaidOut = $conn->prepare($sqlSumAmountPaidOut);
$stmtSumAmountPaidOut->bind_param("s", $user_id2);
$stmtSumAmountPaidOut->execute();
$stmtSumAmountPaidOut->bind_result($sumAmountPaidOut);
$stmtSumAmountPaidOut->fetch();
$stmtSumAmountPaidOut->close();




$sqlSumDepositoLiquido = "SELECT SUM(deposito_liquido) AS sumDepositoLiquido 
    FROM solicitacoes 
    WHERE user_id = ? AND status = 'PAID_OUT' 
    AND (
        tipo_transacao != 'CREDIT_CARD' 
        OR (tipo_transacao = 'CREDIT_CARD' AND (saque_disponivel IS NULL OR saque_disponivel <= NOW()))
    )";
$stmtSumDepositoLiquido = $conn->prepare($sqlSumDepositoLiquido);
$stmtSumDepositoLiquido->bind_param("s", $user_id2);
$stmtSumDepositoLiquido->execute();
$stmtSumDepositoLiquido->bind_result($sumDepositoLiquido);
$stmtSumDepositoLiquido->fetch();
$stmtSumDepositoLiquido->close();


// Consultar a data real mais recente (se necessário)
$sqlRealDate = "SELECT MAX(real_data) AS realDate FROM solicitacoes WHERE user_id = ?";
$stmtRealDate = $conn->prepare($sqlRealDate);
$stmtRealDate->bind_param("i", $user_id);
$stmtRealDate->execute();
$stmtRealDate->bind_result($realDate);
$stmtRealDate->fetch();
$stmtRealDate->close();


// Consultar a soma dos saques aprovados
$sqlSumSaquesAprovados = "SELECT SUM(amount) AS sumSaquesAprovados FROM solicitacoes_cash_out WHERE user_id = ? AND status = 'COMPLETED'";
$stmtSumSaquesAprovados = $conn->prepare($sqlSumSaquesAprovados);
$stmtSumSaquesAprovados->bind_param("s", $user_id2);
$stmtSumSaquesAprovados->execute();
$stmtSumSaquesAprovados->bind_result($sumSaquesAprovados);
$stmtSumSaquesAprovados->fetch();
$stmtSumSaquesAprovados->close();


// Calcular o saldo líquido
$saldoliquido = $sumDepositoLiquido - ($sumSaquesAprovados ?: 0); // Se não houver saques aprovados, considera 0

// Calcular saldo total (incluindo bloqueado) e saldo bloqueado
$sqlSaldoTotal = "SELECT SUM(deposito_liquido) AS saldoTotal 
    FROM solicitacoes 
    WHERE user_id = ? AND status = 'PAID_OUT'";
$stmtSaldoTotal = $conn->prepare($sqlSaldoTotal);
$stmtSaldoTotal->bind_param("s", $user_id2);
$stmtSaldoTotal->execute();
$stmtSaldoTotal->bind_result($saldoTotal);
$stmtSaldoTotal->fetch();
$stmtSaldoTotal->close();

$sqlSaldoBloqueado = "SELECT SUM(deposito_liquido) AS saldoBloqueado 
    FROM solicitacoes 
    WHERE user_id = ? AND status = 'PAID_OUT' 
    AND tipo_transacao = 'CREDIT_CARD' 
    AND saque_disponivel IS NOT NULL 
    AND saque_disponivel > NOW()";
$stmtSaldoBloqueado = $conn->prepare($sqlSaldoBloqueado);
$stmtSaldoBloqueado->bind_param("s", $user_id2);
$stmtSaldoBloqueado->execute();
$stmtSaldoBloqueado->bind_result($saldoBloqueado);
$stmtSaldoBloqueado->fetch();
$stmtSaldoBloqueado->close();

$saldoTotal = $saldoTotal ?: 0;
$saldoBloqueado = $saldoBloqueado ?: 0;

// Fechar a conexão
$conn->close();


?>









<!-- Este código gera o URL base do site combinando o protocolo, o nome de domínio e o caminho do diretório -->
<?php
    $baseUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']) . '/../';
?>
<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code generates the base URL for the website by combining the protocol, domain name, and directory path -->

<!-- This code is useful for internal styles  -->
<?php ob_start(); ?>



<?php $styles = ob_get_clean(); ?>
<!-- This code is useful for internal styles  -->

<!-- This code is useful for content -->
<?php ob_start(); ?>


<script>
    // Recuperar o user_id do PHP e imprimir no console
    const userId = <?php echo json_encode($_SESSION['user_id']); ?>;
    console.log("User ID:", userId);
  </script>




            <div class="main-content app-content">
                <div class="container-fluid">

                    <!-- Start::page-header -->
                    <div class="d-flex align-items-center justify-content-between my-4 page-header-breadcrumb flex-wrap gap-2">
                   



                     
                    </div>
                    <!-- End::page-header -->

                    <!-- Start:: row-1 -->
                    <div class="row">
                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="card custom-card">
                                <div class="card-body p-4">
                                    <div class="d-flex align-items-start justify-content-between">
                                        <div>
                                            <div>
                                                <span class="d-block mb-2">DISPONÍVEL PARA SAQUE</span>
                                                <h5 class="mb-4 fs-4">R$  <?php echo safe_number_format($saldoliquido, 2, ',', '.'); ?></h5>
                                            </div>
                                            <span class="text-success me-2 fw-medium d-inline-block"></span><span class="text-muted">SALDO DISPONÍVEL</span>
                                        </div>
                                        <div>
                                            <div class="main-card-icon success">
                                                <div class="avatar avatar-lg bg-success-transparent border border-success border-opacity-10">
                                                    <div class="avatar avatar-sm svg-white">
                                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M40,192a16,16,0,0,0,16,16H216a8,8,0,0,0,8-8V88a8,8,0,0,0-8-8H56A16,16,0,0,1,40,64Z" opacity="0.2"></path><path d="M40,64V192a16,16,0,0,0,16,16H216a8,8,0,0,0,8-8V88a8,8,0,0,0-8-8H56A16,16,0,0,1,40,64h0A16,16,0,0,1,56,48H192" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path><circle cx="180" cy="140" r="12"></circle></svg>   </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                            <div class="card custom-card main-card">
                                <div class="card-body p-4">
                                    <div class="d-flex align-items-start justify-content-between">
                                        <div>
                                            <div>
                                                <span class="d-block mb-2">DISPONIVEL PARA SAQUE</span>
                                                <h5 class="mb-4 fs-4">R$ <?php echo safe_number_format($saldoliquido, 2, ',', '.'); ?></h5>
                                            </div>
                                            <span class="text-success me-2 fw-medium d-inline-block"></span><span class="text-muted">SALDO DISPONIVEL</span>
                                        </div>
                                        <div>
                                        <div class="main-card-icon success">
                                                <div class="avatar avatar-lg bg-success-transparent border border-success border-opacity-10">
                                                    <div class="avatar avatar-sm svg-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" fill="#000000" viewBox="0 0 256 256"><path d="M200,168a48.05,48.05,0,0,1-48,48H136v16a8,8,0,0,1-16,0V216H104a48.05,48.05,0,0,1-48-48,8,8,0,0,1,16,0,32,32,0,0,0,32,32h48a32,32,0,0,0,0-64H112a48,48,0,0,1,0-96h8V24a8,8,0,0,1,16,0V40h8a48.05,48.05,0,0,1,48,48,8,8,0,0,1-16,0,32,32,0,0,0-32-32H112a32,32,0,0,0,0,64h40A48.05,48.05,0,0,1,200,168Z"></path></svg>
                                                    </div>
                                                </div>
                                            </div>
                                      
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <?php if ($saldoBloqueado > 0): ?>
                        <div class="col-12">
                            <div class="card custom-card">
                                <div class="card-body p-4">
                                    <div class="d-flex align-items-start justify-content-between">
                                        <div>
                                            <div>
                                                <span class="d-block mb-2">SALDO BLOQUEADO (CARTÃO DE CRÉDITO)</span>
                                                <h5 class="mb-4 fs-4 text-warning">R$ <?php echo safe_number_format($saldoBloqueado, 2, ',', '.'); ?></h5>
                                            </div>
                                            <span class="text-warning me-2 fw-medium d-inline-block"></span><span class="text-muted">AGUARDANDO LIBERAÇÃO</span>
                                        </div>
                                        <div>
                                            <div class="main-card-icon warning">
                                                <div class="avatar avatar-lg bg-warning-transparent border border-warning border-opacity-10">
                                                    <div class="avatar avatar-sm svg-white">
                                                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"><rect width="256" height="256" fill="none"></rect><path d="M40,192a16,16,0,0,0,16,16H216a8,8,0,0,0,8-8V88a8,8,0,0,0-8-8H56A16,16,0,0,1,40,64Z" opacity="0.2"></path><path d="M40,64V192a16,16,0,0,0,16,16H216a8,8,0,0,0,8-8V88a8,8,0,0,0-8-8H56A16,16,0,0,1,40,64h0A16,16,0,0,1,56,48H192" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16"></path><circle cx="180" cy="140" r="12"></circle></svg>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                  
                        
                    </div>
                    <!-- End:: row-1 -->






                    
                    <?php
$saldoBaixo = $sumDepositoLiquido < 5;
?>

  

<?php
// Verifica se $sumDepositoLiquido está vazio ou não definido
if (empty($sumDepositoLiquido)) {
    $sumDepositoLiquido = 0;
}
?>




<!-- Start::row-1 -->
<div class="row">
    <div class="col-xl-6">
        <div class="card custom-card">
            <div class="card-body p-0">
                <div class="p-3 d-grid border-bottom border-block-end-dashed">
                    <button class="btn btn-primary d-flex align-items-center justify-content-center" 
                            data-bs-toggle="modal" 
                            data-bs-target="#addtask" 
                            data-saldo="<?php echo htmlspecialchars($saldoliquido); ?>">
                        <i class="ri-add-circle-line fs-16 align-middle me-1"></i> Solicitar saque
                    </button>
                    
                    <!-- Modal -->
                    <div class="modal fade" id="addtask" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h6 class="modal-title" id="mail-ComposeLabel">Novo Saque</h6>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <form id="saqueForm" method="POST" action="insert_retirada.php" enctype="multipart/form-data">
                                    <div class="modal-body px-4">
                                        <div class="row gy-2">

                                            <!-- Verificação de saldo baixo -->
                                            <?php if ($saldoBaixo): ?>
                                                <div class="alert alert-danger mt-4">
                                                    <strong>Saldo muito baixo para realizar um saque.</strong>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Mensagens de erro específicas -->
                                            <?php if ($erro === 'saldo_insuficiente'): ?>
                                                <div class="alert alert-danger mt-4">
                                                    <strong>Saldo insuficiente para realizar o saque solicitado.</strong>
                                                </div>
                                            <?php elseif ($erro === 'saldo_bloqueado'): ?>
                                                <div class="alert alert-warning mt-4">
                                                    <strong>Parte do seu saldo está temporariamente indisponível.</strong><br>
                                                    <small>Você tem R$ <?php echo number_format($valorBloqueado, 2, ',', '.'); ?> bloqueado por transações de cartão de crédito que ainda não estão disponíveis para saque. O saldo será liberado conforme o prazo estabelecido pelo adquirente.</small>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Verificação de saque em processamento -->
                                            <?php
                                            include '../conectarbanco.php';
                                                // Conectar ao banco de dados
                                            $conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

                                            // Verificar conexão
                                            if ($conn->connect_error) {
                                                die("Falha na conexão: " . $conn->connect_error);
                                            }
                                            // Consultar se já existe um saque em processamento
                                            $sqlCheck = "SELECT COUNT(*) as count FROM retiradas WHERE user_id = ? AND status = '0'";
                                            $stmtCheck = $conn->prepare($sqlCheck);
                                            $stmtCheck->bind_param("s", $user_id);
                                            $stmtCheck->execute();
                                            $stmtCheck->bind_result($count);
                                            $stmtCheck->fetch();
                                            $stmtCheck->close();

                                            if ($count > 0): ?>
                                                <div class="alert alert-warning mt-4">
                                                    <strong>Já existe um saque em processamento. Aguarde a conclusão.</strong>
                                                </div>
                                            <?php endif; ?>

                                            <!-- Exibição do saldo disponível -->
                                            <div class="alert alert-info mt-4">
                                                <ul>
                                                    <li><strong>DISPONÍVEL PARA SAQUE:</strong> R$: <?php echo safe_number_format($saldoliquido, 2, ',', '.'); ?></li>
                                                </ul>
                                            </div>

                                            <!-- Campo de valor -->
                                            <div class="col-xl-12">
                                                <label for="valor" class="form-label">Valor</label>
                                                <input type="text" step="0.01" class="form-control" id="valor" name="valor" placeholder="Valor" required>
                                                <div id="valorError" class="text-danger mt-2" style="display: none;">Saldo insuficiente para o valor solicitado.</div>
                                            </div>

                                            <div class="col-xl-12">
                                                <label for="tipo_chave" class="form-label">Tipo de Chave PIX</label>
                                                <select class="form-control" id="tipo_chave" name="tipo_chave" required>
                                                    <option value="CPF">CPF</option>
                                                    <option value="CNPJ">CNPJ</option>
                                                    <option value="EMAIL">E-mail</option>
                                                    <option value="PHONE">Telefone</option>
                                                    <option value="RANDOM_KEY">Chave Aleatória</option>
                                                </select>
                                            </div>

                                            <div class="col-xl-12">
                                                <label for="chave" class="form-label">Chave PIX:</label>
                                                <input type="text" class="form-control" id="chave" name="chave" placeholder="Digite o CPF (apenas números)" required>
                                                <div id="chaveError" class="text-danger mt-2" style="display: none;"></div>
                                            </div>

                                            <!-- Campo oculto para o ID do usuário -->
                                            <input type="hidden" id="user_id" name="user_id" value="<?php echo htmlspecialchars($email); ?>">
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-light" data-bs-dismiss="modal">Cancelar</button>
                                        <button type="submit" class="btn btn-primary" <?php echo ($count > 0) ? 'disabled' : ''; ?>>Solicitar</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Explicação sobre taxas padrão -->
                <div class="alert alert-info mt-4">
                    <ul>
                        <li><strong>Taxa de saque:</strong> R$: <?php echo htmlspecialchars($taxa_cash_out); ?></li>
                        <li><strong>Limite Pessoa física:</strong> R$ 5.000,00 /mês</li>
                        <li><strong>Limite Pessoa jurídica:</strong> Sem limite</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End::row-1 -->

<script>
document.getElementById('saqueForm').addEventListener('submit', function(event) {
    var saldo = <?php echo $saldoliquido; ?>; // Corrigido para usar PHP para obter o saldo
    var valor = parseFloat(document.getElementById('valor').value);
    var valorError = document.getElementById('valorError');
    
    // Verifica se o saldo é zero ou se o valor solicitado é maior que o saldo
    if (saldo <= 0) {
        valorError.textContent = 'Saldo insuficiente para realizar um saque.';
        valorError.style.display = 'block';
        event.preventDefault(); // Evita o envio do formulário
    } else if (valor > saldo) {
        valorError.textContent = 'Saldo insuficiente para o valor solicitado.';
        valorError.style.display = 'block';
        event.preventDefault(); // Evita o envio do formulário
    } else {
        valorError.style.display = 'none'; // Oculta a mensagem de erro se tudo estiver certo
    }
});

// Validação do tipo de chave PIX
document.getElementById('tipo_chave').addEventListener('change', function() {
    var tipoChave = this.value;
    var chaveInput = document.getElementById('chave');
    var chaveError = document.getElementById('chaveError') || createChaveErrorElement();
    
    // Limpa o campo de chave quando o tipo muda
    chaveInput.value = '';
    chaveError.style.display = 'none';
    
    // Atualiza o placeholder baseado no tipo selecionado
    switch(tipoChave) {
        case 'CPF':
            chaveInput.placeholder = 'Digite o CPF (apenas números)';
            break;
        case 'CNPJ':
            chaveInput.placeholder = 'Digite o CNPJ (apenas números)';
            break;
        case 'EMAIL':
            chaveInput.placeholder = 'Digite o e-mail';
            break;
        case 'PHONE':
            chaveInput.placeholder = 'Digite o telefone (DDD número)';
            break;
        case 'RANDOM_KEY':
            chaveInput.placeholder = 'Digite a chave aleatória';
            break;
    }
    
    // Remove qualquer formatação existente
    chaveInput.style.textTransform = 'none';
});

// Validação da chave PIX
document.getElementById('chave').addEventListener('input', function() {
    var tipoChave = document.getElementById('tipo_chave').value;
    var chave = this.value;
    var chaveError = document.getElementById('chaveError') || createChaveErrorElement();
    
    var isValid = true;
    var errorMessage = '';
    
    switch(tipoChave) {
        case 'CPF':
            // Remove formatação para validar apenas números
            var chaveLimpa = chave.replace(/\D/g, '');
            if (chaveLimpa.length !== 11 || !/^\d{11}$/.test(chaveLimpa)) {
                isValid = false;
                errorMessage = 'CPF deve ter 11 dígitos numéricos';
            }
            break;
        case 'CNPJ':
            // Remove formatação para validar apenas números
            var chaveLimpa = chave.replace(/\D/g, '');
            if (chaveLimpa.length !== 14 || !/^\d{14}$/.test(chaveLimpa)) {
                isValid = false;
                errorMessage = 'CNPJ deve ter 14 dígitos numéricos';
            }
            break;
        case 'EMAIL':
            if (!/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(chave)) {
                isValid = false;
                errorMessage = 'Digite um e-mail válido';
            }
            break;
        case 'PHONE':
            // Remove formatação para validar apenas números
            // var chaveLimpa = chave.replace(/\D/g, '');
            // if (!/^55\d{10,11}$/.test(chaveLimpa)) {
            //     isValid = false;
            //     errorMessage = 'Telefone deve estar no formato +55DDDNUMERO';
            // }
            break;
        case 'RANDOM_KEY':
            if (chave.length < 10) {
                isValid = false;
                errorMessage = 'Chave aleatória deve ter pelo menos 10 caracteres';
            }
            break;
    }
    
    if (!isValid) {
        chaveError.textContent = errorMessage;
        chaveError.style.display = 'block';
    } else {
        chaveError.style.display = 'none';
    }
});

// Função para criar elemento de erro da chave se não existir
function createChaveErrorElement() {
    var chaveInput = document.getElementById('chave');
    var chaveError = document.createElement('div');
    chaveError.id = 'chaveError';
    chaveError.className = 'text-danger mt-2';
    chaveError.style.display = 'none';
    chaveInput.parentNode.appendChild(chaveError);
    return chaveError;
}
</script>








<?php
session_start();

// Verificar se o e-mail está presente na sessão
if (!isset($_SESSION['email'])) {
    // Se o e-mail não estiver presente na sessão, redirecione para outra página
    header("Location: ../");
    exit; // Certifique-se de sair do script após o redirecionamento
}

include '../conectarbanco.php';

// Obter o e-mail da sessão
$email = $_SESSION['email'];

// Conectar ao banco de dados
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifique a conexão
if ($conn->connect_error) {
    die("Falha na conexão: " . $conn->connect_error);
}

// Obter o user_id com base no e-mail da sessão
$sqlUserId = $conn->prepare("SELECT user_id FROM users WHERE email = ?");
$sqlUserId->bind_param('s', $email);
$sqlUserId->execute();
$resultUserId = $sqlUserId->get_result();

if ($resultUserId->num_rows == 0) {
    echo "Usuário não encontrado.";
    $sqlUserId->close();
    $conn->close();
    exit;
}

$userRow = $resultUserId->fetch_assoc();
$user_id = $userRow['user_id'];
$sqlUserId->close();

// Configurações de paginação
$limit = 10; // Número de registros por página
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1; // Página atual
$offset = ($page - 1) * $limit;

// Consulta para obter o número total de registros com user_id igual ao e-mail da sessão
$totalResult = $conn->prepare("SELECT COUNT(*) AS total FROM retiradas WHERE user_id = ?");
$totalResult->bind_param('s', $user_id);
$totalResult->execute();
$totalRow = $totalResult->get_result()->fetch_assoc();
$totalRecords = $totalRow['total'];
$totalPages = ceil($totalRecords / $limit);

// Consulta para obter os registros com user_id igual ao e-mail da sessão
$sql = "SELECT id, referencia, valor, valor_liquido, tipo_chave, chave, status, data_solicitacao, data_pagamento, taxa_cash_out 
        FROM retiradas 
        WHERE user_id = ?
        ORDER BY data_solicitacao DESC 
        LIMIT ? OFFSET ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sii", $user_id, $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();
?>

<!-- Start::row-2 -->
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-header justify-content-between">
                <div class="card-title">
                    Retiradas
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table text-nowrap table-bordered">
                        <thead>
                            <tr>
                               
                                <th scope="col">Valor</th>
                                <th scope="col">Valor Líquido</th>
                                <th scope="col">Tipo de Chave</th>
                                <th scope="col">Chave</th>
                                <th scope="col">Status</th>
                                <th scope="col">Data de Solicitação</th>
                            
                              
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            if ($result->num_rows > 0) {
                                // Itera sobre os resultados e exibe cada linha na tabela
                                while ($row = $result->fetch_assoc()) {
                                    $statusBadge = 'bg-light text-dark';
                                    $statusText = 'Pendente';
                                    if ((string)$row['status'] === '1') {
                                        $statusBadge = 'bg-success-transparent';
                                        $statusText = 'Pago';
                                    } elseif ((string)$row['status'] === '5') {
                                        $statusBadge = 'bg-danger-transparent';
                                        $statusText = 'Recusado';
                                    }
                                    echo "<tr>";
                                  
                                    echo "<td>{$row['valor']}</td>";
                                    echo "<td>{$row['valor_liquido']}</td>";
                                    echo "<td>{$row['tipo_chave']}</td>";
                                    echo "<td>{$row['chave']}</td>";
                                    echo "<td><span class='badge {$statusBadge}'>{$statusText}</span></td>";
                                    echo "<td>{$row['data_solicitacao']}</td>";
                                  
                                   
                                    echo "</tr>";
                                }
                            } else {
                                echo "<tr><td colspan='9'>Nenhum registro encontrado</td></tr>";
                            }
                            $stmt->close();
                            $conn->close();
                            ?>
                        </tbody>
                    </table>
                </div>
                <!-- Paginação -->
                <nav aria-label="Page navigation">
                    <ul class="pagination justify-content-center">
                        <li class="page-item <?= ($page <= 1) ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page=<?= $page - 1 ?>" aria-label="Previous">
                                <span aria-hidden="true">&laquo;</span>
                            </a>
                        </li>
                        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                            <li class="page-item <?= ($i == $page) ? 'active' : '' ?>">
                                <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
                            </li>
                        <?php endfor; ?>
                        <li class="page-item <?= ($page >= $totalPages) ? 'disabled' : '' ?>">
                            <a class="page-link" href="?page=<?= $page + 1 ?>" aria-label="Next">
                                <span aria-hidden="true">&raquo;</span>
                            </a>
                        </li>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<!-- End::row-2 -->






                   

                </div>
            </div>

<?php $content = ob_get_clean(); ?>
<!-- This code is useful for content -->

<!-- This code is useful for internal scripts  -->
<?php ob_start(); ?>

        <!-- Apex Charts JS -->
        <script src="<?php echo $baseUrl; ?>/assets/libs/apexcharts/apexcharts.min.js"></script>
        
 

<?php $scripts = ob_get_clean(); ?>
<!-- This code is useful for internal scripts  -->

<!-- This code use for render base file -->
<?php include '../layouts/base.php'; ?>
<!-- This code use for render base file -->

 








<!-- Internal Apex Area Charts JS -->
<script src="../assets/js/apexcharts-area.js"></script>

<script>
// Formatação inteligente baseada no tipo de chave selecionado
document.getElementById('chave').addEventListener('input', function (e) {
    var tipoChave = document.getElementById('tipo_chave').value;
    var value = e.target.value;
    
    // Remove formatação existente para CPF e CNPJ
    if (tipoChave === 'CPF' || tipoChave === 'CNPJ') {
        value = value.replace(/\D/g, '');
        
        if (tipoChave === 'CPF' && value.length <= 11) {
            e.target.value = value
                .replace(/(\d{3})(\d)/, '$1.$2')
                .replace(/(\d{3})(\d)/, '$1.$2')
                .replace(/(\d{3})(\d{1,2})$/, '$1-$2');
        } else if (tipoChave === 'CNPJ' && value.length <= 14) {
            e.target.value = value
                .replace(/(\d{2})(\d)/, '$1.$2')
                .replace(/(\d{3})(\d)/, '$1.$2')
                .replace(/(\d{3})(\d)/, '$1/$2')
                .replace(/(\d{4})(\d{1,2})$/, '$1-$2');
        } else {
            e.target.value = value;
        }
    } else {
        // Para outros tipos (EMAIL, PHONE, RANDOM_KEY), não aplica formatação
        e.target.value = value;
    }
});
</script>

<script>
document.getElementById('valor').addEventListener('input', function(e) {
    let value = e.target.value;

    // Remove todos os caracteres que não sejam números e vírgulas
    value = value.replace(/\D/g, '');

    // Se o campo não estiver vazio, converte o valor para formato decimal
    if (value.length > 0) {
        value = (parseFloat(value) / 100).toFixed(2); // Adiciona as casas decimais
        value = value.replace('.', ','); // Substitui o ponto por vírgula
        value = value.replace(/\B(?=(\d{3})+(?!\d))/g, '.'); // Adiciona os pontos de milhar
    }

    // Atualiza o campo de valor com a formatação correta
    e.target.value = value;
});
</script>





