<?php
include '../../conectarbanco.php';  // Conectar ao banco de dados
include 'alerta_customizado.php';


// Conectar ao banco de dados
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

// Verifica se houve algum erro na conexão
if ($conn->connect_error) {
  die("Erro na conexão com o banco de dados: " . $conn->connect_error);
}

// Verifica se o parâmetro 'id' está presente na URL
if (isset($_GET['id'])) {
  // Recupera o valor do parâmetro 'id'
  $id = $_GET['id'];

  // Sanitiza o valor do parâmetro
  $id = preg_replace('/[^a-zA-Z0-9_\-]/', '', $id);

  // Construa a consulta SQL para procurar o id na coluna url_checkout
  $sql = "SELECT checkout_build.id, name_produto, valor, logo_produto, banner_produto, obrigado_page, key_gateway, ativo, checkout_build.email, users.user_id as user_id, parcelavel, max_parcelas
            FROM checkout_build
            inner join users on users.cliente_id = checkout_build.key_gateway
            WHERE url_checkout LIKE ?";

  // Adiciona o ID sanitizado ao padrão de busca com LIKE
  $id_like = "%?id=" . $id . "%";

  // Prepara e executa a consulta
  $stmt = $conn->prepare($sql);
  $stmt->bind_param("s", $id_like);
  $stmt->execute();

  // Obtém os resultados
  $result = $stmt->get_result();

  // Verifica se há resultados
  if ($result->num_rows > 0) {
    // Exibe os dados encontrados
    $row = $result->fetch_assoc();

    // Busca as credenciais de integração do Meta Ads e Google Ads
    $user_id_for_integrations = $row['user_id'];
    $sql_integrations = "SELECT meta_pixel, meta_token, google_snippet_code, google_label FROM integracoes_ads WHERE user_id = ?";
    $stmt_integrations = $conn->prepare($sql_integrations);
    $stmt_integrations->bind_param("s", $user_id_for_integrations);
    $stmt_integrations->execute();
    $result_integrations = $stmt_integrations->get_result();
    $integrations_row = $result_integrations->fetch_assoc();
    $stmt_integrations->close();

  } else {
    $row = null;
    $integrations_row = null; // Garante que seja null se não houver produto
    echo "Nenhum registro encontrado para o ID especificado.";
  }

  // Fecha a declaração
  $stmt->close();
} else {
  echo "Parâmetro 'id' não encontrado na URL.";
}

// Fecha a conexão
$conn->close();

// Extrai os dados das integrações para variáveis PHP
$metaPixel = isset($integrations_row['meta_pixel']) ? $integrations_row['meta_pixel'] : '';
$metaAccessToken = isset($integrations_row['meta_token']) ? $integrations_row['meta_token'] : '';
$googleSnippetCode = isset($integrations_row['google_snippet_code']) ? $integrations_row['google_snippet_code'] : '';
$googleLabel = isset($integrations_row['google_label']) ? $integrations_row['google_label'] : '';

$obrigadoUrl = '/checkout/obrigado/';
if (isset($row) && is_array($row) && !empty($row['obrigado_page'])) {
  $obrigadoPage = $row['obrigado_page'];
  // Se a URL não começar com http:// ou https://, adiciona https://
  if (!preg_match('/^https?:\/\//', $obrigadoPage)) {
    $obrigadoUrl = 'https://' . $obrigadoPage;
  } else {
    $obrigadoUrl = $obrigadoPage;
  }
}
function safe_number_format($num, $decimals = 2, $dec_point = ',', $thousands_sep = '.')
{
  // Aceita strings nos formatos "3,33", "3.33", "1.234,56" e "1,234.56"
  if (is_string($num)) {
    $clean = trim($num);

    // Converte vírgula decimal para ponto, preservando apenas o último ponto como decimal
    $clean = str_replace(',', '.', $clean);
    // Mantém apenas dígitos e pontos
    $clean = preg_replace('/[^0-9.]/', '', $clean);
    // Se houver mais de um ponto, o último é o decimal; os anteriores são milhares e devem ser removidos
    if (substr_count($clean, '.') > 1) {
      $parts = explode('.', $clean);
      $last = array_pop($parts);
      $clean = implode('', $parts) . '.' . $last; // remove pontos de milhar
    }
    $num = $clean;
  }

  if ($num === '' || !is_numeric($num)) {
    $num = 0;
  }

  return number_format((float)$num, $decimals, $dec_point, $thousands_sep);
}


?>



<!DOCTYPE html>
<html lang="pt-br">

<head>
  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <meta data-n-head="1" data-hid="description" name="description" content="">
  <meta data-n-head="1" name="format-detection" content="telephone=no">
  <meta data-n-head="1" data-hid="og:image" property="og:image" content="/meta-img.png">
  <title>Checkout </title>
  <link data-n-head="1" rel="icon" type="image/x-icon" href="">
  <style type="text/css">
    .__nuxt-error-page {
      align-items: center;
      background: #f7f8fb;
      color: #47494e;
      display: flex;
      flex-direction: column;
      font-family: sans-serif;
      font-weight: 100 !important;
      justify-content: center;
      padding: 1rem;
      text-align: center;
      -ms-text-size-adjust: 100%;
      -webkit-text-size-adjust: 100%;
      -webkit-font-smoothing: antialiased;
      bottom: 0;
      left: 0;
      position: absolute;
      right: 0;
      top: 0
    }

    .__nuxt-error-page .error {
      max-width: 450px
    }

    .__nuxt-error-page .title {
      color: #47494e;
      font-size: 1.5rem;
      margin-bottom: 8px;
      margin-top: 15px
    }

    .__nuxt-error-page .description {
      color: #7f828b;
      line-height: 21px;
      margin-bottom: 10px
    }

    .__nuxt-error-page a {
      color: #7f828b !important;
      -webkit-text-decoration: none;
      text-decoration: none
    }

    .__nuxt-error-page .logo {
      bottom: 12px;
      left: 12px;
      position: fixed
    }
  </style>
  <style type="text/css">
    @import url(https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap);
  </style>
  <style type="text/css">
    @import url(https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap);
  </style>
  <style type="text/css">
    @import url(https://fonts.googleapis.com/css2?family=Azeret+Mono:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,900&display=swap);
  </style>
  <style type="text/css">
    @font-face {
      font-display: swap;
      font-family: "FFBase";
      font-style: normal;
      font-weight: 400;
      src: url(/_nuxt/fonts/ff-400.07a6b16.woff2)
    }

    @font-face {
      font-display: swap;
      font-family: "FFBase";
      font-style: normal;
      font-weight: 600;
      src: url(/_nuxt/fonts/ff-600.6925648.woff2)
    }

    @font-face {
      font-display: swap;
      font-family: "FFBase";
      font-style: normal;
      font-weight: 700;
      src: url(/_nuxt/fonts/ff-700.6d8fedb.woff2)
    }

    :root {
      --primary-font: "FFBase", sans-serif;
      --bs-body-font-family: var(--bs-font-sans-serif);
      --inter: "Inter", sans-serif;
      --azeretMono: "Azeret Mono", monospace;
      --bs-font-sans-serif: "Sora", -apple-system, "BlinkMacSystemFont", "Helvetica", "Lato", "Arial", "Segoe UI", "Verdana", sans-serif;
      --bs-font-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
      --title_great: 2.5em;
      --title: 2rem;
      --title_med: 1.25rem;
      --detail: 1rem;
      --font-simple: 14px;
      --largeheader: 100%;
      --largeSideBar: 16rem;
      --largewithAside: calc(var(--largeheader) - var(--largeSideBar));
      --primary-color-main-light: #f45152;
      --primary-color-main-dark: #ec2121;
      --primary-color-main: #e93636;
      --red: #ef4444;
      --primary-outline: rgba(241, 99, 99, .41);
      --secondary-color: #6366f1;
      --redBlur: rgba(239, 68, 68, .12);
      --blue: #4c82f7;
      --blue-1: rgba(76, 130, 247, .12);
      --blue-2: #4475de;
      --blue-3: #edf3fe;
      --blue-4: #a6c1fb;
      --black: #120f1e;
      --black-1: #131022;
      --white: #fff;
      --white-1: rgba(99, 102, 241, .12);
      --white-2: hsla(0, 0%, 100%, .7);
      --white-3: #f2f2f7;
      --white-4: #cfd8f6;
      --white-5: #dfe4f6;
      --dark-grey: #e2e5f1;
      --dark-grey-2: #3e4265;
      --dark-grey-3: rgba(62, 66, 101, .8);
      --dark-grey-4: #b0b1d1;
      --grey: #585c7b;
      --grey-0: rgba(176, 177, 209, .17);
      --grey-1: #d4d7e5;
      --grey-2: #ececec;
      --grey-3: hsla(0, 0%, 100%, .2);
      --grey-4: hsla(0, 0%, 100%, .05);
      --grey-5: #9397ad;
      --grey-6: #eff2fc;
      --grey-7: rgba(63, 65, 168, .369);
      --grey-8: #868e96;
      --grey-9: rgba(61, 61, 61, .439);
      --grey-10: #f3f5fd;
      --grey-11: #b8bac7;
      --grey-12: #a6aac0;
      --green: #12b034;
      --green-1: #0f8329;
      --green-3: #22c55e;
      --green-4: rgba(34, 197, 94, .12);
      --green-5: #6cc447;
      --green-6: rgba(34, 197, 94, .439);
      --yellow: #d29800;
      --yellow-1: rgba(255, 186, 8, .12);
      --yellow-2: #daa520;
      --yellow-3: rgba(255, 248, 230, .612);
      --yellow-4: #ffdd84;
      --dividing-line-primary: var(--dark-grey);
      --dividing-line-secondary: rgba(0, 0, 0, .05);
      --input-border: var(--grey-1);
      --warning: var(--grey-5);
      --alert-error-color: #d73d3d;
      --alert-error-background: rgba(239, 68, 68, .05);
      --alert-error-border: rgba(239, 68, 68, .25);
      --primary-main-shadow: 0 0.5rem 1.125rem -0.5rem rgba(241, 99, 99, .55);
      --secondary-main-shadow: 0 0.1rem 1.125rem -0.1rem #f16363;
      --secondary-shadow: 0 0.5rem 1.125rem -0.5rem rgba(99, 102, 241, .9);
      --secondary-shadow-2: 0 -0.5rem 1.125rem -0.5rem rgba(99, 102, 241, .9);
      --tertiary-shadow: inset 0 0 0 transparent, 0 0.5rem 1.125rem -0.5rem rgba(99, 102, 241, .2);
      --content-shadow: 0 0.3rem 1.525rem -0.375rem rgba(19, 16, 34, .1), 0 0.25rem 0.8125rem -0.125rem rgba(19, 16, 34, .06);
      --item-space-plus: 40px;
      --item-space-simple: 2rem;
      --item-space-detail: 1.5rem;
      --border-simple: 0.3rem;
      --border-plus: 0.5rem;
      --border-med: 10px;
      --slow-detail: 0.15s;
      --slow-min: 0.3s;
      --slow-main: 0.4s;
      --body-line-height: 1.6;
      --body-letter-spacing: .3px;
      --regular: 400;
      --wight-med: 600;
      --bold: 700;
      --scroll-main-background: #aaa;
      --alert-header: var(--green);
      --alert-body: var(--white-3);
      --alert-title: var(--white);
      --alert-description: var(--grey);
      --alert-progressBar: var(--green);
      --red-accent: #ec1e1f;
      --green-lime: #3dc705;
      --green-dark: #283930;
      --green-success: #08be4b;
      --green-buy: #08cb50;
      --blue-buy: #0247e3;
      --green-success-faded: #edf7f2;
      --input-focus-border-color: #85b7d9;
      --bs-blue: #0d6efd;
      --bs-indigo: #6610f2;
      --bs-purple: #6f42c1;
      --bs-pink: #d63384;
      --bs-red: #dc3545;
      --bs-orange: #fd7e14;
      --bs-yellow: #ffc107;
      --bs-green: #198754;
      --bs-teal: #20c997;
      --bs-cyan: #0dcaf0;
      --bs-white: #fff;
      --bs-gray: #9397ad;
      --bs-gray-dark: #4c4e5e;
      --bs-gray-100: #f3f6ff;
      --bs-gray-200: #eff2fc;
      --bs-gray-300: #e2e5f1;
      --bs-gray-400: #d4d7e5;
      --bs-gray-500: #b4b7c9;
      --bs-gray-600: #9397ad;
      --bs-gray-700: #585c7b;
      --bs-gray-800: #3e4265;
      --bs-gray-900: #131022;
      --bs-primary: #6366f1;
      --bs-secondary: #eff2fc;
      --bs-success: #22c55e;
      --bs-info: #4c82f7;
      --bs-warning: #ffba08;
      --bs-danger: #ef4444;
      --bs-light: #fff;
      --bs-dark: #131022;
      --bs-primary-rgb: 244, 81, 82;
      --bs-secondary-rgb: 239, 242, 252;
      --bs-success-rgb: 34, 197, 94;
      --bs-info-rgb: 76, 130, 247;
      --bs-warning-rgb: 255, 186, 8;
      --bs-danger-rgb: 239, 68, 68;
      --bs-light-rgb: 255, 255, 255;
      --bs-dark-rgb: 19, 16, 34;
      --bs-white-rgb: 255, 255, 255;
      --bs-black-rgb: 0, 0, 0;
      --bs-body-color-rgb: 88, 92, 123;
      --bs-body-bg-rgb: 255, 255, 255;
      --bs-body-color: #585c7b;
      --bs-body-bg: #ececec;
      --primary-red: #e93636;
      --primary-red-dark: #ec2121;
      --primary-red-light: #f45152;
      --primary-blue: #6366f1
    }

    html {
      overflow-x: hidden;
      overflow-y: scroll
    }

    * {
      scroll-behavior: smooth
    }

    body * {
      box-sizing: border-box;
      font-family: "Inter", sans-serif;
      font-family: var(--inter);
      font-size: 1rem;
      font-size: var(--detail);
      font-weight: 400;
      font-weight: var(--regular);
      line-height: 1.6;
      line-height: var(--body-line-height);
      margin: 0;
      text-align: var(--bs-body-text-align);
      -webkit-text-size-adjust: 100%;
      -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
      letter-spacing: .3px;
      letter-spacing: var(--body-letter-spacing)
    }

    body {
      background-color: #ececec
    }

    body,
    p {
      color: #585c7b;
      color: var(--grey);
      margin: 0;
      padding: 0
    }

    body.dark-mode {
      --grey-0: var(--grey-4);
      --alert-header: var(--green);
      --alert-body: var(--white-3);
      --alert-title: var(--black);
      --alert-description: var(--white-2);
      --alert-progressBar: var(--green);
      --border-input: var(--grey-3)
    }

    body.dark-mode,
    body.dark-mode p {
      --scroll-main-background: #3d3950;
      --white: #140f22;
      --white-3: #1e1b29;
      --black: #fff;
      --dark-grey: hsla(0, 0%, 100%, .15);
      --dark-grey-2: hsla(0, 0%, 100%, .85);
      --dividing-line-primary: hsla(0, 0%, 100%, .15);
      --dividing-line-secondary: hsla(0, 0%, 100%, .05);
      color: hsla(0, 0%, 100%, .7);
      color: var(--white-2)
    }

    a,
    button,
    label {
      cursor: pointer
    }

    button,
    img,
    label,
    th {
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none
    }

    a {
      color: inherit
    }

    h1,
    h2,
    h3,
    h4,
    h5,
    h6 {
      letter-spacing: -.45px;
      -webkit-font-smoothing: subpixel-antialiased !important;
      color: #120f1e;
      color: var(--black);
      font-weight: 800;
      line-height: 1.3;
      margin: 0
    }

    input[type=number]::-webkit-inner-spin-button,
    input[type=number]::-webkit-outer-spin-button {
      -webkit-appearance: none;
      margin: 0
    }

    input.is-invalid:focus:before,
    input:invalid:focus:before {
      color: red;
      content: "Campo obrigatorio";
      display: block
    }

    .input-wrapper input.is-invalid,
    .input-wrapper input:invalid {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9IiNlZjQ0NDQiPjxwYXRoIGQ9Ik03LjY0MyAxMy41MzVMMTAgMTEuMTc4bDIuMzU3IDIuMzU3IDEuMTc4LTEuMTc4TDExLjE3OCAxMGwyLjM1Ny0yLjM1Ny0xLjE3OC0xLjE3OEwxMCA4LjgyMiA3LjY0MyA2LjQ2NSA2LjQ2NSA3LjY0MyA4LjgyMiAxMGwtMi4zNTcgMi4zNTcgMS4xNzggMS4xNzh6TTEwIDE4LjMzM2M0LjU5NSAwIDguMzMzLTMuNzM4IDguMzMzLTguMzMzUzE0LjU5NSAxLjY2NyAxMCAxLjY2NyAxLjY2NyA1LjQwNSAxLjY2NyAxMCA1LjQwNSAxOC4zMzMgMTAgMTguMzMzem0wLTE1YzMuNjc2IDAgNi42NjcgMi45OTEgNi42NjcgNi42NjdTMTMuNjc2IDE2LjY2NyAxMCAxNi42NjcgMy4zMzMgMTMuNjc2IDMuMzMzIDEwIDYuMzI0IDMuMzMzIDEwIDMuMzMzeiIvPjwvc3ZnPg==);
      background-position: right calc(.4em + .3125rem) center;
      background-repeat: no-repeat;
      background-size: calc(.8em + .625rem) calc(.8em + .625rem);
      border-color: #ef4444;
      padding-right: calc(1.6em + 1.25rem)
    }

    .input-wrapper input.is-invalid:hover,
    .input-wrapper input:hover:invalid {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9IiNlZjQ0NDQiPjxwYXRoIGQ9Ik03LjY0MyAxMy41MzVMMTAgMTEuMTc4bDIuMzU3IDIuMzU3IDEuMTc4LTEuMTc4TDExLjE3OCAxMGwyLjM1Ny0yLjM1Ny0xLjE3OC0xLjE3OEwxMCA4LjgyMiA3LjY0MyA2LjQ2NSA2LjQ2NSA3LjY0MyA4LjgyMiAxMGwtMi4zNTcgMi4zNTcgMS4xNzggMS4xNzh6TTEwIDE4LjMzM2M0LjU5NSAwIDguMzMzLTMuNzM4IDguMzMzLTguMzMzUzE0LjU5NSAxLjY2NyAxMCAxLjY2NyAxLjY2NyA1LjQwNSAxLjY2NyAxMCA1LjQwNSAxOC4zMzMgMTAgMTguMzMzem0wLTE1YzMuNjc2IDAgNi42NjcgMi45OTEgNi42NjcgNi42NjdTMTMuNjc2IDE2LjY2NyAxMCAxNi42NjcgMy4zMzMgMTMuNjc2IDMuMzMzIDEwIDYuMzI0IDMuMzMzIDEwIDMuMzMzeiIvPjwvc3ZnPg==);
      background-position: right calc(.4em + .3125rem) center;
      background-repeat: no-repeat;
      background-size: calc(.8em + .625rem) calc(.8em + .625rem);
      border-color: #ef4444;
      padding-right: calc(1.6em + 1.25rem)
    }

    .input-wrapper input.is-invalid:focus,
    .input-wrapper input:focus:invalid {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9IiNlZjQ0NDQiPjxwYXRoIGQ9Ik03LjY0MyAxMy41MzVMMTAgMTEuMTc4bDIuMzU3IDIuMzU3IDEuMTc4LTEuMTc4TDExLjE3OCAxMGwyLjM1Ny0yLjM1Ny0xLjE3OC0xLjE3OEwxMCA4LjgyMiA3LjY0MyA2LjQ2NSA2LjQ2NSA3LjY0MyA4LjgyMiAxMGwtMi4zNTcgMi4zNTcgMS4xNzggMS4xNzh6TTEwIDE4LjMzM2M0LjU5NSAwIDguMzMzLTMuNzM4IDguMzMzLTguMzMzUzE0LjU5NSAxLjY2NyAxMCAxLjY2NyAxLjY2NyA1LjQwNSAxLjY2NyAxMCA1LjQwNSAxOC4zMzMgMTAgMTguMzMzem0wLTE1YzMuNjc2IDAgNi42NjcgMi45OTEgNi42NjcgNi42NjdTMTMuNjc2IDE2LjY2NyAxMCAxNi42NjcgMy4zMzMgMTMuNjc2IDMuMzMzIDEwIDYuMzI0IDMuMzMzIDEwIDMuMzMzeiIvPjwvc3ZnPg==);
      background-position: right calc(.4em + .3125rem) center;
      background-repeat: no-repeat;
      background-size: calc(.8em + .625rem) calc(.8em + .625rem);
      border-color: #ef4444;
      padding-right: calc(1.6em + 1.25rem)
    }

    input:-webkit-autofill,
    input:-webkit-autofill:focus,
    input:-webkit-autofill:hover,
    select:-webkit-autofill,
    select:-webkit-autofill:focus,
    select:-webkit-autofill:hover,
    textarea:-webkit-autofill,
    textarea:-webkit-autofill:hover textarea:-webkit-autofill:focus {
      border: 1px solid #d4d7e5;
      border: 1px solid var(--grey-1);
      -webkit-text-fill-color: #585c7b !important;
      -webkit-text-fill-color: var(--grey) !important;
      -webkit-box-shadow: inset 0 0 0 1000px #fff;
      -webkit-transition: background-color 5000s ease-in-out 0s;
      transition: background-color 5000s ease-in-out 0s
    }

    input,
    textarea {
      -webkit-appearance: none;
      -moz-appearance: none;
      appearance: none;
      background-clip: padding-box;
      background-color: #fff;
      background-color: var(--white);
      border: 1px solid #d4d7e5;
      border: 1px solid var(--grey-1);
      border-radius: .3rem;
      border-radius: var(--border-simple);
      box-shadow: inset 0 0 0 transparent;
      color: #585c7b;
      color: var(--grey);
      display: block;
      font-weight: 400;
      padding: .625rem 1rem;
      transition: .3s;
      transition: var(--slow-min);
      -webkit-user-select: text;
      -moz-user-select: text;
      user-select: text;
      width: 100%
    }

    .btn,
    input,
    textarea {
      font-size: .875rem;
      line-height: 1.6
    }

    .btn {
      background-color: transparent;
      border: 1px solid transparent;
      border-radius: .375rem;
      color: #585c7b;
      cursor: pointer;
      display: inline-block;
      font-weight: 600;
      padding: .625rem 1.75rem;
      text-align: center;
      -webkit-text-decoration: none;
      text-decoration: none;
      transition: color .2s ease-in-out, background-color .2s ease-in-out, border-color .2s ease-in-out, box-shadow .2s ease-in-out;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none;
      vertical-align: middle;
      white-space: nowrap
    }

    input:focus {
      border-color: #85b7d9;
      border-color: var(--input-focus-border-color);
      outline: none
    }

    .fade-leave-active {
      transition: opacity .4s
    }

    .fade-enter,
    .fade-leave-to {
      opacity: 0
    }

    .fadeDown-enter-active {
      animation: fadeDown .2s linear
    }

    .fadeDown-leave-active {
      animation: fadeDown .2s linear reverse;
      display: none
    }

    .fadeDown {
      animation: fadeDown .2s ease-in-out
    }

    @keyframes fadeDown {
      0% {
        opacity: 0;
        transform: translateY(-10px)
      }

      to {
        display: block;
        opacity: 1;
        transform: translateY(0)
      }
    }

    .checkbox-content label {
      cursor: pointer;
      font-size: .875rem;
      font-weight: 400;
      margin: 0 0 0 10px
    }

    .checkbox-content i {
      font-size: inherit;
      font-style: italic;
      font-weight: inherit;
      opacity: .7
    }

    .checkbox-content p {
      color: #585c7b;
      color: var(--grey);
      font-size: .9rem;
      font-weight: 400;
      line-height: 1.6
    }

    input[type=checkbox] {
      cursor: pointer;
      display: inline-block;
      height: 18px;
      overflow: hidden;
      padding: 0;
      position: relative;
      width: 18px
    }

    input[type=checkbox]:before {
      content: "";
      display: block;
      height: 100%;
      left: 0;
      position: absolute;
      top: 0;
      width: 100%
    }

    input[type=checkbox]:checked:after {
      animation: checkSacle .4s;
      background-color: #08be4b;
      background-color: var(--green-success);
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZmlsbD0ibm9uZSIgc3Ryb2tlPSIjZmZmIiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiIHN0cm9rZS13aWR0aD0iMyIgZD0iTTYgMTBsMyAzbDYtNiIvPjwvc3ZnPg==);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: 100%;
      border-color: #08be4b;
      border-color: var(--green-success);
      content: "";
      display: block;
      height: 100%;
      position: relative;
      width: 100%;
      z-index: 1
    }

    @keyframes checkSacle {
      0% {
        background-size: 120%;
        opacity: 0
      }

      to {
        opacity: 1
      }
    }

    .input-icons:before {
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      content: "";
      display: block;
      height: 100%;
      left: .5rem;
      opacity: .7;
      position: absolute;
      top: 0;
      width: 20px
    }



    .email-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9ImN1cnJlbnRDb2xvciIgdmlld0JveD0iMCAwIDE2IDE2Ij4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik0wIDRhMiAyIDAgMCAxIDItMmgxMmEyIDIgMCAwIDEgMiAydjhhMiAyIDAgMCAxLTIgMkgyYTIgMiAwIDAgMS0yLTJWNFptMi0xYTEgMSAwIDAgMC0xIDF2LjIxN2w3IDQuMiA3LTQuMlY0YTEgMSAwIDAgMC0xLTFIMlptMTMgMi4zODMtNC43MDggMi44MjVMMTUgMTEuMTA1VjUuMzgzWm0tLjAzNCA2Ljg3Ni01LjY0LTMuNDcxTDggOS41ODNsLTEuMzI2LS43OTUtNS42NCAzLjQ3QTEgMSAwIDAgMCAyIDEzaDEyYTEgMSAwIDAgMCAuOTY2LS43NDFaTTEgMTEuMTA1bDQuNzA4LTIuODk3TDEgNS4zODN2NS43MjJaIi8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvc3ZnPg==);
      width: 18px
    }

    .padlock-icon:before {
      background-image: url(/_nuxt/img/028b070.svg);
      width: 18px
    }

    .phone-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9ImN1cnJlbnRDb2xvciIgdmlld0JveD0iMCAwIDE2IDE2Ij4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHBhdGggZD0iTTMuNjU0IDEuMzI4YS42NzguNjc4IDAgMCAwLTEuMDE1LS4wNjNMMS42MDUgMi4zYy0uNDgzLjQ4NC0uNjYxIDEuMTY5LS40NSAxLjc3YTE3LjU2OCAxNy41NjggMCAwIDAgNC4xNjggNi42MDggMTcuNTY5IDE3LjU2OSAwIDAgMCA2LjYwOCA0LjE2OGMuNjAxLjIxMSAxLjI4Ni4wMzMgMS43Ny0uNDVsMS4wMzQtMS4wMzRhLjY3OC42NzggMCAwIDAtLjA2My0xLjAxNWwtMi4zMDctMS43OTRhLjY3OC42NzggMCAwIDAtLjU4LS4xMjJsLTIuMTkuNTQ3YTEuNzQ1IDEuNzQ1IDAgMCAxLTEuNjU3LS40NTlMNS40ODIgOC4wNjJhMS43NDUgMS43NDUgMCAwIDEtLjQ2LTEuNjU3bC41NDgtMi4xOWEuNjc4LjY3OCAwIDAgMC0uMTIyLS41OEwzLjY1NCAxLjMyOHpNMS44ODQuNTExYTEuNzQ1IDEuNzQ1IDAgMCAxIDIuNjEyLjE2M0w2LjI5IDIuOThjLjMyOS40MjMuNDQ1Ljk3NC4zMTUgMS40OTRsLS41NDcgMi4xOWEuNjc4LjY3OCAwIDAgMCAuMTc4LjY0M2wyLjQ1NyAyLjQ1N2EuNjc4LjY3OCAwIDAgMCAuNjQ0LjE3OGwyLjE4OS0uNTQ3YTEuNzQ1IDEuNzQ1IDAgMCAxIDEuNDk0LjMxNWwyLjMwNiAxLjc5NGMuODI5LjY0NS45MDUgMS44Ny4xNjMgMi42MTFsLTEuMDM0IDEuMDM0Yy0uNzQuNzQtMS44NDYgMS4wNjUtMi44NzcuNzAyYTE4LjYzNCAxOC42MzQgMCAwIDEtNy4wMS00LjQyIDE4LjYzNCAxOC42MzQgMCAwIDEtNC40Mi03LjAwOWMtLjM2Mi0xLjAzLS4wMzctMi4xMzcuNzAzLTIuODc3TDEuODg1LjUxMXoiLz4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3N2Zz4=);
      width: 16px
    }

    .credit-card-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9IiMwZDZlZmQiIHZpZXdCb3g9IjAgMCAxNiAxNiI+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik0wIDRhMiAyIDAgMCAxIDItMmgxMmEyIDIgMCAwIDEgMiAydjhhMiAyIDAgMCAxLTIgMkgyYTIgMiAwIDAgMS0yLTJWNHptMi0xYTEgMSAwIDAgMC0xIDF2MWgxNFY0YTEgMSAwIDAgMC0xLTFIMnptMTMgNEgxdjVhMSAxIDAgMCAwIDEgMWgxMmExIDEgMCAwIDAgMS0xVjd6Ii8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik0yIDEwYTEgMSAwIDAgMSAxLTFoMWExIDEgMCAwIDEgMSAxdjFhMSAxIDAgMCAxLTEgMUgzYTEgMSAwIDAgMS0xLTF2LTF6Ii8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9zdmc+);
      filter: brightness(0);
      width: 18px
    }

    .input-icons input {
      padding-left: 2.35rem
    }

    .tab-button:before {
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      content: "";
      display: block;
      height: 100%;
      transition: .4s;
      transition: var(--slow-main);
      width: 20px
    }

    #creditCard.tab-button:before {
      filter: grayscale(1)
    }

    #creditCard.tab-button.active:before,
    #creditCard.tab-button:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGZpbGw9IiMwZDZlZmQiIHZpZXdCb3g9IjAgMCAxNiAxNiI+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik0wIDRhMiAyIDAgMCAxIDItMmgxMmEyIDIgMCAwIDEgMiAydjhhMiAyIDAgMCAxLTIgMkgyYTIgMiAwIDAgMS0yLTJWNHptMi0xYTEgMSAwIDAgMC0xIDF2MWgxNFY0YTEgMSAwIDAgMC0xLTFIMnptMTMgNEgxdjVhMSAxIDAgMCAwIDEgMWgxMmExIDEgMCAwIDAgMS0xVjd6Ii8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik0yIDEwYTEgMSAwIDAgMSAxLTFoMWExIDEgMCAwIDEgMSAxdjFhMSAxIDAgMCAxLTEgMUgzYTEgMSAwIDAgMS0xLTF2LTF6Ii8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9zdmc+);
      height: 18px;
      width: 18px
    }

    #creditCard.tab-button.active:before {
      filter: hue-rotate(286deg)
    }

    #pix.tab-button:before {
      filter: grayscale(1)
    }

    #pix.tab-button.active:before,
    #pix.tab-button:before {
      background-image: url(/_nuxt/img/31b5835.svg);
      height: 20px;
      width: 20px
    }

    #pix.tab-button.active:before {
      filter: none
    }

    #billet.tab-button:before {
      filter: grayscale(1);
      opacity: .5
    }

    #billet.tab-button.active:before,
    #billet.tab-button:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxuczp4bGluaz0iaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluayIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiBhcmlhLWhpZGRlbj0idHJ1ZSIgZm9jdXNhYmxlPSJmYWxzZSIgZGF0YS1wcmVmaXg9ImZhbCIgZGF0YS1pY29uPSJiYXJjb2RlLWFsdCIgcm9sZT0iaW1nIiB2aWV3Qm94PSIwIDAgNjQwIDUxMiIgY2xhc3M9InN2Zy1pbmxpbmUtLWZhIGZhLWJhcmNvZGUtYWx0IGZhLXctMjAgZmEtM3giIGZpbGw9IiMyMzIzMjMiIHdpZHRoPSIyMCIgaGVpZ2h0PSIxNiI+CiAgICA8cGF0aCBkPSJNMjgwIDk2aC0xNmMtNC40IDAtOCAzLjYtOCA4djMwNGMwIDQuNCAzLjYgOCA4IDhoMTZjNC40IDAgOC0zLjYgOC04VjEwNGMwLTQuNC0zLjYtOC04LTh6bS02NCAwaC0xNmMtNC40IDAtOCAzLjYtOCA4djMwNGMwIDQuNCAzLjYgOCA4IDhoMTZjNC40IDAgOC0zLjYgOC04VjEwNGMwLTQuNC0zLjYtOC04LTh6TTU5MiAwSDQ4QzIxLjUgMCAwIDIxLjUgMCA0OHY0MTZjMCAyNi41IDIxLjUgNDggNDggNDhoNTQ0YzI2LjUgMCA0OC0yMS41IDQ4LTQ4VjQ4YzAtMjYuNS0yMS41LTQ4LTQ4LTQ4em0xNiA0NjRjMCA4LjgtNy4yIDE2LTE2IDE2SDQ4Yy04LjggMC0xNi03LjItMTYtMTZWNDhjMC04LjggNy4yLTE2IDE2LTE2aDU0NGM4LjggMCAxNiA3LjIgMTYgMTZ2NDE2ek0xNTIgOTZoLTQ4Yy00LjQgMC04IDMuNi04IDh2MzA0YzAgNC40IDMuNiA4IDggOGg0OGM0LjQgMCA4LTMuNiA4LThWMTA0YzAtNC40LTMuNi04LTgtOHptMzg0IDBoLTQ4Yy00LjQgMC04IDMuNi04IDh2MzA0YzAgNC40IDMuNiA4IDggOGg0OGM0LjQgMCA4LTMuNiA4LThWMTA0YzAtNC40LTMuNi04LTgtOHptLTEyOCAwaC00OGMtNC40IDAtOCAzLjYtOCA4djMwNGMwIDQuNCAzLjYgOCA4IDhoNDhjNC40IDAgOC0zLjYgOC04VjEwNGMwLTQuNC0zLjYtOC04LTh6IiBjbGFzcz0iIi8+Cjwvc3ZnPg==);
      height: 20px;
      width: 20px
    }

    #billet.tab-button.active:before {
      filter: none;
      opacity: 1
    }

    .grey-padlock-icon,
    .safe-icon {
      align-items: center;
      display: flex;
      filter: grayscale(1);
      gap: .5rem
    }

    .grey-padlock-icon:before,
    .safe-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGNsYXNzPSJtZS0xIiB3aWR0aD0iMTgiIGhlaWdodD0iMTgiIHZpZXdCb3g9IjAgMCAyNCAyNCIgc3R5bGU9ImZpbGw6IHJnYigyMDcsIDY4LCA2OCk7Ij4KICAgICAgICAgICAgPHBhdGggZD0iTTIwIDEyYzAtMS4xMDMtLjg5Ny0yLTItMmgtMVY3YzAtMi43NTctMi4yNDMtNS01LTVTNyA0LjI0MyA3IDd2M0g2Yy0xLjEwMyAwLTIgLjg5Ny0yIDJ2OGMwIDEuMTAzLjg5NyAyIDIgMmgxMmMxLjEwMyAwIDItLjg5NyAyLTJ2LTh6TTkgN2MwLTEuNjU0IDEuMzQ2LTMgMy0zczMgMS4zNDYgMyAzdjNIOVY3eiI+PC9wYXRoPgogICAgICAgICAgPC9zdmc+);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      content: "";
      display: block;
      min-height: 16px;
      min-width: 16px
    }

    .safe-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHN0eWxlPSJtYXJnaW4tcmlnaHQ6IDAuMzVyZW07IGZpbGw6IHJnYigyMDcsIDY4LCA2OCk7IiB3aWR0aD0iMTYiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAxNiAxNiI+CiAgICAgICAgICAgIDxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgZD0iTTggMGMtLjY5IDAtMS44NDMuMjY1LTIuOTI4LjU2LTEuMTEuMy0yLjIyOS42NTUtMi44ODcuODdhMS41NCAxLjU0IDAgMCAwLTEuMDQ0IDEuMjYyYy0uNTk2IDQuNDc3Ljc4NyA3Ljc5NSAyLjQ2NSA5Ljk5YTExLjc3NyAxMS43NzcgMCAwIDAgMi41MTcgMi40NTNjLjM4Ni4yNzMuNzQ0LjQ4MiAxLjA0OC42MjUuMjguMTMyLjU4MS4yNC44MjkuMjRzLjU0OC0uMTA4LjgyOS0uMjRhNy4xNTkgNy4xNTkgMCAwIDAgMS4wNDgtLjYyNSAxMS43NzUgMTEuNzc1IDAgMCAwIDIuNTE3LTIuNDUzYzEuNjc4LTIuMTk1IDMuMDYxLTUuNTEzIDIuNDY1LTkuOTlhMS41NDEgMS41NDEgMCAwIDAtMS4wNDQtMS4yNjMgNjIuNDY3IDYyLjQ2NyAwIDAgMC0yLjg4Ny0uODdDOS44NDMuMjY2IDguNjkgMCA4IDB6bTIuMTQ2IDUuMTQ2YS41LjUgMCAwIDEgLjcwOC43MDhsLTMgM2EuNS41IDAgMCAxLS43MDggMGwtMS41LTEuNWEuNS41IDAgMSAxIC43MDgtLjcwOEw3LjUgNy43OTNsMi42NDYtMi42NDd6Ij48L3BhdGg+CiAgICAgICAgICA8L3N2Zz4=)
    }

    .check-circle-icon {
      align-items: center;
      display: inline-flex;
      gap: .5rem;
      position: relative;
      top: 5px
    }

    .check-circle-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGNsYXNzPSJpY29uIGljb24tdGFibGVyIGljb24tdGFibGVyLWNpcmNsZS1jaGVjayBtZS0xIiB3aWR0aD0iMTgiIGhlaWdodD0iMTgiIHZpZXdCb3g9IjAgMCAyNCAyNCIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2U9ImN1cnJlbnRDb2xvciIgZmlsbD0ibm9uZSIgc3Ryb2tlLWxpbmVjYXA9InJvdW5kIiBzdHJva2UtbGluZWpvaW49InJvdW5kIiBzdHlsZT0ibWFyZ2luLWJvdHRvbToycHg7IGNvbG9yOiAjNGE2Y2Y3OyI+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICA8cGF0aCBzdHJva2U9Im5vbmUiIGQ9Ik0wIDBoMjR2MjRIMHoiIGZpbGw9Im5vbmUiLz4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxjaXJjbGUgY3g9IjEyIiBjeT0iMTIiIHI9IjkiLz4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxwYXRoIGQ9Ik05IDEybDIgMmw0IC00Ii8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDwvc3ZnPg==);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      content: "";
      display: inline-block;
      filter: hue-rotate(-80deg);
      min-height: 18px;
      min-width: 18px
    }

    .alert-timer-icon,
    .alertError-icon,
    .download-icon,
    .hand-icon {
      align-items: center;
      display: flex;
      gap: .5rem
    }

    .alert-timer-icon:before,
    .alertError-icon:before,
    .download-icon:before,
    .hand-icon:before {
      background-image: url(/_nuxt/img/69739b8.png);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      content: "";
      display: inline-block;
      min-height: 24px;
      min-width: 24px
    }

    .alertError-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCIgZmlsbD0iI2VmNDQ0NCIgc3R5bGU9IndpZHRoOiAyMHB4OyBoZWlnaHQ6MjBweDsgbWFyZ2luLXJpZ2h0OjhweDsiPgogICAgICAgICAgICAgIDxwYXRoIGZpbGwtcnVsZT0iZXZlbm9kZCIgZD0iTTE4IDEwYTggOCAwIDExLTE2IDAgOCA4IDAgMDExNiAwem0tOC01YS43NS43NSAwIDAxLjc1Ljc1djQuNWEuNzUuNzUgMCAwMS0xLjUgMHYtNC41QS43NS43NSAwIDAxMTAgNXptMCAxMGExIDEgMCAxMDAtMiAxIDEgMCAwMDAgMnoiIGNsaXAtcnVsZT0iZXZlbm9kZCI+PC9wYXRoPgogICAgICAgICAgICA8L3N2Zz4=);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      min-height: 20px;
      min-width: 20px
    }

    .download-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBzdHlsZT0iZmlsbDogcmdiYSgyNTUsIDI1NSwgMjU1LCAxKTt0cmFuc2Zvcm06IDttc0ZpbHRlcjo7Ij48cGF0aCBkPSJtMTIgMTYgNC01aC0zVjRoLTJ2N0g4eiI+PC9wYXRoPjxwYXRoIGQ9Ik0yMCAxOEg0di03SDJ2N2MwIDEuMTAzLjg5NyAyIDIgMmgxNmMxLjEwMyAwIDItLjg5NyAyLTJ2LTdoLTJ2N3oiPjwvcGF0aD48L3N2Zz4=);
      min-height: 16px;
      min-width: 16px
    }

    .alert-timer-icon:before {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBzdHlsZT0iZmlsbDogcmdiYSgxNDEsIDEwNiwgMTcsIDEpO3RyYW5zZm9ybTogO21zRmlsdGVyOjsiPjxwYXRoIGQ9Im0yMC4xNDUgOC4yNyAxLjU2My0xLjU2My0xLjQxNC0xLjQxNEwxOC41ODYgN2MtMS4wNS0uNjMtMi4yNzQtMS0zLjU4Ni0xLTMuODU5IDAtNyAzLjE0LTcgN3MzLjE0MSA3IDcgNyA3LTMuMTQgNy03YTYuOTY2IDYuOTY2IDAgMCAwLTEuODU1LTQuNzN6TTE1IDE4Yy0yLjc1NyAwLTUtMi4yNDMtNS01czIuMjQzLTUgNS01IDUgMi4yNDMgNSA1LTIuMjQzIDUtNSA1eiI+PC9wYXRoPjxwYXRoIGQ9Ik0xNCAxMGgydjRoLTJ6bS0xLTdoNHYyaC00ek0zIDhoNHYySDN6bTAgOGg0djJIM3ptLTEtNGgzLjk5djJIMnoiPjwvcGF0aD48L3N2Zz4=);
      min-height: 20px;
      min-width: 20px
    }

    .tootipContent {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxNiIgaGVpZ2h0PSIxNiIgZmlsbD0iIzU1NTU1NSIgdmlld0JveD0iMCAwIDE2IDE2Ij4KICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPHBhdGggZD0iTTggMTZBOCA4IDAgMSAwIDggMGE4IDggMCAwIDAgMCAxNnptLjkzLTkuNDEyLTEgNC43MDVjLS4wNy4zNC4wMjkuNTMzLjMwNC41MzMuMTk0IDAgLjQ4Ny0uMDcuNjg2LS4yNDZsLS4wODguNDE2Yy0uMjg3LjM0Ni0uOTIuNTk4LTEuNDY1LjU5OC0uNzAzIDAtMS4wMDItLjQyMi0uODA4LTEuMzE5bC43MzgtMy40NjhjLjA2NC0uMjkzLjAwNi0uMzk5LS4yODctLjQ3bC0uNDUxLS4wODEuMDgyLS4zODEgMi4yOS0uMjg3ek04IDUuNWExIDEgMCAxIDEgMC0yIDEgMSAwIDAgMSAwIDJ6Ii8+CiAgICAgICAgICAgICAgICAgICAgICAgICAgICA8L3N2Zz4=);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      cursor: pointer;
      height: 100%;
      position: absolute;
      right: .5rem;
      top: 0;
      width: 16px
    }

    .tooltip {
      left: 0;
      min-width: 200px;
      position: absolute;
      top: 50%;
      transform: translate(calc(-100% - 1rem), -50%);
      will-change: transform;
      z-index: 10000
    }

    .tooltip .tooltip-inner {
      background-color: #000;
      border-radius: .25rem;
      color: #fff;
      font-size: .8rem;
      max-width: 200px;
      padding: .25rem .5rem;
      text-align: center
    }

    .tooltip .tooltip-arrow {
      border-bottom: 5px solid transparent;
      border-left: 5px solid #000;
      border-top: 5px solid transparent;
      height: 0;
      position: absolute;
      right: 0;
      top: 50%;
      transform: translate(100%, -50%);
      width: 0
    }

    .tooltip[x-placement^=top] {
      margin-bottom: 5px
    }

    .tooltip[x-placement^=top] .tooltip-arrow {
      border-bottom-color: transparent !important;
      border-left-color: transparent !important;
      border-right-color: transparent !important;
      border-width: 5px 5px 0;
      bottom: -5px;
      left: calc(50% - 5px);
      margin-bottom: 0;
      margin-top: 0
    }

    .tooltip[x-placement^=bottom] {
      margin-top: 5px
    }

    .tooltip[x-placement^=bottom] .tooltip-arrow {
      border-left-color: transparent !important;
      border-right-color: transparent !important;
      border-top-color: transparent !important;
      border-width: 0 5px 5px;
      left: calc(50% - 5px);
      margin-bottom: 0;
      margin-top: 0;
      top: -5px
    }

    .tooltip[x-placement^=right] {
      margin-left: 5px
    }

    .tooltip[x-placement^=right] .tooltip-arrow {
      border-bottom-color: transparent !important;
      border-left-color: transparent !important;
      border-top-color: transparent !important;
      border-width: 5px 5px 5px 0;
      left: -5px;
      margin-left: 0;
      margin-right: 0;
      top: calc(50% - 5px)
    }

    .tooltip[x-placement^=left] {
      margin-right: 5px
    }

    .tooltip[x-placement^=left] .tooltip-arrow {
      border-bottom-color: transparent !important;
      border-right-color: transparent !important;
      border-top-color: transparent !important;
      border-width: 5px 0 5px 5px;
      margin-left: 0;
      margin-right: 0;
      right: -5px;
      top: calc(50% - 5px)
    }

    .tooltip.popover .popover-inner {
      background: #f9f9f9;
      border-radius: 5px;
      box-shadow: 0 5px 30px rgba(black, .1);
      color: #000;
      padding: 24px
    }

    .tooltip.popover .popover-arrow {
      border-color: #f9f9f9
    }

    .tooltip[aria-hidden=true] {
      opacity: 0;
      transition: opacity .15s, visibility .15s;
      visibility: hidden
    }

    .tooltip[aria-hidden=false] {
      opacity: 1;
      transition: opacity .15s;
      visibility: visible
    }

    .backgroundBanner {
      background-repeat: no-repeat;
      background-size: 100% auto;
      filter: blur(15px);
      height: 60vh;
      left: 0;
      opacity: .75;
      position: absolute;
      top: -5rem;
      width: 100%;
      z-index: -1
    }

    .backgroundBanner:after {
      background-image: linear-gradient(0deg, #ececec, transparent 40%);
      background-size: 100%;
      content: "";
      height: 100%;
      position: absolute;
      width: 100%
    }

    header {
      align-items: center;
      background-color: #000;
      display: flex;
      gap: 2rem;
      justify-content: center;
      left: 0;
      padding: 1.1rem;
      position: relative;
      top: 0;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none;
      width: 100%;
      z-index: 100
    }

    header h2 {
      font-family: "Azeret Mono", monospace !important;
      font-family: var(--azeretMono) !important;
      font-size: calc(1.325rem + .9vw);
      font-weight: 600
    }

    header h2,
    header p {
      color: #fff;
      color: var(--white)
    }

    header p {
      font-size: 1.1rem;
      font-weight: 700
    }

    header .progressBar {
      background-color: brown;
      bottom: 0;
      height: 10px;
      left: 0;
      position: absolute;
      transform: translateY(100%);
      width: 100%
    }

    header .progressBar .bar {
      background-color: #12b034;
      background-color: var(--green);
      display: block;
      height: 10px;
      width: 40px
    }

    main {
      background-repeat: no-repeat;
      margin: 30px auto 0;
      max-width: 900px;
      width: calc(100% - 2rem)
    }

    main .bannerImage {
      line-height: 1em;
      overflow: hidden;
      width: 100%
    }

    main .bannerImage img {
      border-radius: .4rem;
      -o-object-fit: cover;
      object-fit: cover;
      -o-object-position: center center;
      object-position: center center;
      width: 100%
    }

    .content-wrapper,
    .content-wrapper.secondary {
      background-color: #fff;
      background-color: var(--white);
      border-radius: .4rem;
      box-shadow: 0 .3rem 1.525rem -.375rem rgba(19, 16, 34, .1), 0 .25rem .8125rem -.125rem rgba(19, 16, 34, .06);
      margin-top: .5rem;
      padding: 1rem 1.75rem 1.5rem;
      width: 100%
    }

    .content-wrapper.secondary {
      padding: 1.5rem 2rem 2.5rem
    }

    .content-wrapper h5 {
      color: #ef4444;
      color: var(--red);
      display: inline-block;
      font-size: 12px;
      font-weight: 700;
      letter-spacing: .25px;
      margin-bottom: .35rem;
      text-transform: uppercase;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none
    }

    .content-wrapper .image-content {
      border-radius: .25rem;
      height: 90px;
      overflow: hidden;
      width: 90px
    }

    .content-wrapper .image-content img {
      height: 100%;
      -o-object-fit: cover;
      object-fit: cover;
      -o-object-position: center;
      object-position: center;
      width: 100%
    }

    .content-wrapper .contentProductData {
      align-items: center;
      display: flex;
      gap: 1rem;
      margin-top: .5rem
    }

    .content-wrapper .contentProductData .infoProduct {
      display: flex;
      flex-direction: column;
      gap: .2rem;
      justify-content: center
    }

    .content-wrapper .contentProductData .infoProduct h4 {
      color: #4c4c4c;
      font-size: 16px;
      font-weight: 700
    }

    .content-wrapper .contentProductData .infoProduct span {
      align-items: center;
      display: flex;
      font-size: 14px;
      font-weight: 400;
      gap: 5px
    }

    .content-wrapper .contentProductData .infoProduct h3 {
      font-size: 1.55rem;
      font-weight: 700;
      margin-bottom: 0
    }

    .content-wrapper h2:first-child {
      margin: 0 0 1.5rem
    }

    .content-wrapper h2 {
      align-items: center;
      background-color: #edf7f2;
      background-color: var(--green-success-faded);
      border-radius: 35px;
      color: #283930;
      color: var(--green-dark);
      display: inline-flex;
      font-size: 16px;
      font-weight: 700;
      gap: 1rem;
      margin: 1.5rem 0;
      padding: 0 1.5rem 0 0;
      text-transform: uppercase;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none
    }

    .content-wrapper h2 .orderNumber {
      align-items: center;
      background-color: #08be4b;
      background-color: var(--green-success);
      border-radius: 45px;
      color: #fff;
      display: flex;
      font-size: 20px;
      font-weight: 700;
      height: 40px;
      justify-content: center;
      position: relative;
      width: 40px;
      z-index: 2
    }

    .input-wrapper {
      line-height: 1em;
      margin-bottom: .5rem;
      width: 100%
    }

    .containerInputs .input-wrapper label,
    .input-wrapper label {
      color: #555;
      display: inline-block;
      font-size: 12px;
      font-weight: 700;
      letter-spacing: .25px;
      margin-top: .5rem;
      text-transform: uppercase
    }

    .input-wrapper input {
      margin-top: .5rem;
      transition: var(--slow)
    }

    .input-wrapper input:focus {
      background-color: #fff;
      border-color: #85b7d9;
      border-color: var(--input-focus-border-color);
      color: #585c7b;
      outline: 0
    }

    .alertText {
      color: #ef4444;
      color: var(--red);
      display: block;
      font-size: .75rem;
      margin-top: .25rem;
      width: 100%
    }

    .tab-header {
      display: flex;
      flex-wrap: nowrap;
      gap: .5rem;
      margin-bottom: 1rem
    }

    .tab-header .tab-button {
      align-items: center;
      background-color: #f8f9fa;
      border: 1px solid rgba(222, 226, 230, .522);
      border-radius: 7px;
      color: #999;
      cursor: pointer;
      display: flex;
      flex-direction: column;
      font-size: .9rem;
      font-weight: 300;
      gap: 7px;
      justify-content: center;
      line-height: 1.25;
      margin-bottom: .25rem;
      max-width: 195px;
      padding: .8rem 1rem;
      transition: .4s ease-in-out;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none;
      width: 100%
    }

    .tab-header .tab-button.active,
    .tab-header .tab-button:hover {
      border: 1px solid #08be4b;
      border: 1px solid var(--green-success);
      color: #06733a
    }

    .dropdownButton,
    .input-icons {
      position: relative
    }

    .dropdownButton {
      cursor: pointer
    }

    .dropdownButton:after {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMS40MTQiIGhlaWdodD0iNy4xMjEiIHZpZXdCb3g9IjAgMCAxMS40MTQgNy4xMjEiPgogIDxwYXRoIGlkPSJieC1jaGV2cm9uLWRvd24iIGQ9Ik0xNi4yOTMsOS4yOTMsMTIsMTMuNTg2LDcuNzA3LDkuMjkzLDYuMjkzLDEwLjcwNywxMiwxNi40MTRsNS43MDctNS43MDdaIiB0cmFuc2Zvcm09InRyYW5zbGF0ZSgtNi4yOTMgLTkuMjkzKSIgZmlsbD0iI2EyYWRiMCIvPgo8L3N2Zz4K);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: contain;
      content: "";
      cursor: pointer;
      height: 10px;
      position: absolute;
      right: 15px;
      top: 50%;
      transform: translateY(-50%);
      transition: .4s;
      transition: var(--slow-main);
      width: 14px
    }

    .dropdownButton.open:after,
    .open .dropdownButton:after {
      background-image: url(data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIxMS40MTQiIGhlaWdodD0iNy4xMjEiIHZpZXdCb3g9IjAgMCAxMS40MTQgNy4xMjEiPgogIDxwYXRoIGlkPSJieC1jaGV2cm9uLXVwIiBkPSJNNi4yOTMsMTMuMjkzbDEuNDE0LDEuNDE0TDEyLDEwLjQxNGw0LjI5Myw0LjI5MywxLjQxNC0xLjQxNEwxMiw3LjU4NloiIHRyYW5zZm9ybT0idHJhbnNsYXRlKC02LjI5MyAtNy41ODYpIiBmaWxsPSIjYTJhZGIwIi8+Cjwvc3ZnPgo=)
    }

    .dropdownButton input {
      cursor: pointer
    }

    .dropdownButton:hover input {
      background-color: #ececec;
      background-color: var(--grey-2)
    }

    .dropdown-menu {
      background-clip: padding-box;
      background-color: #fff;
      background-color: var(--white);
      border: 1px solid #85b7d9;
      border: 1px solid var(--input-focus-border-color);
      border-radius: .5rem;
      box-shadow: 0 .275rem 1.25rem rgba(19, 16, 34, .05), 0 .25rem .5625rem rgba(19, 16, 34, .03);
      color: #585c7b;
      color: var(--grey);
      font-size: .875rem;
      list-style: none;
      overflow: hidden;
      padding: 0;
      position: absolute;
      text-align: left;
      top: 0;
      transform: translateY(calc(-100% - .5rem));
      transition: .15s ease-in-out;
      transition: var(--slow-detail) ease-in-out;
      width: 100%;
      z-index: 70
    }

    .dropdown-menu li {
      background-color: #fff;
      color: #4c4c4c;
      font-size: 14px;
      font-weight: 400;
      padding: .4em 1em;
      transition: all .3s ease-in-out;
      transition: all .3s ease-in-out, font-weight .2s ease-in-out
    }

    .dropdown-menu li:hover {
      background-color: #d4e7f9
    }

    .containerInputs {
      align-items: flex-start;
      display: flex;
      flex-direction: row;
      gap: .5rem;
      width: 100%
    }

    #tabBillet,
    #tabPIX {
      margin-bottom: 2rem
    }

    .tab-content h4 {
      color: #353535;
      font-size: 1rem;
      font-weight: 700;
      margin-bottom: 1rem
    }

    .tab-content h3 {
      color: #08be4b;
      color: var(--green-success);
      display: inline-flex;
      font-size: 1rem;
      font-weight: 700;
      margin-top: .75rem;
      text-transform: uppercase;
      width: 100%
    }

    .tab-content p {
      font-size: 14px;
      font-weight: inherit;
      margin-top: .5rem
    }

    .order-bump-content .titleContentBump {
      background-color: #ec1e1f;
      background-color: var(--red-accent);
      border-radius: .35rem .35rem 0 0;
      color: #fff;
      display: block;
      font-size: 16px;
      font-weight: 700;
      margin: .75rem 0 0;
      padding: 1rem;
      text-align: center;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none;
      width: 100%
    }

    .order-bump-content .main-bump {
      border: 3px dashed #ec1e1f;
      border: 3px dashed var(--red-accent);
      border-radius: 0 0 .5rem .5rem;
      border-top: 0
    }

    .order-bump-content .offerInformation {
      align-content: flex-start;
      border-bottom: 1px solid #e2e5f1;
      cursor: pointer;
      display: flex;
      gap: .5rem;
      padding: 1rem;
      transition: .3s ease-in-out
    }

    .order-bump-content .offerInformation:hover {
      background-color: #f1f1f1
    }

    .order-bump-content .offerInformation:last-child {
      border: 0
    }

    .order-bump-content .offerInformation .image-content {
      border: 1px solid hsla(0, 0%, 60%, .133);
      border-radius: .25rem;
      box-shadow: 0 .3rem 1.525rem -.375rem rgba(19, 16, 34, .1), 0 .25rem .8125rem -.125rem rgba(19, 16, 34, .06);
      height: 45px;
      width: 45px
    }

    .order-bump-content .offerInformation .image-content img {
      height: 100%;
      -o-object-fit: cover;
      object-fit: cover;
      -o-object-position: center center;
      object-position: center center;
      width: 100%
    }

    .order-bump-content .offerInformation .order-bumb-info {
      display: flex;
      flex-direction: column;
      gap: .3rem;
      line-height: 1em
    }

    .order-bump-content .offerInformation .order-bumb-info h5 {
      color: #131022;
      font-size: .9rem;
      font-weight: 700;
      margin: 0;
      text-transform: none
    }

    .order-bump-content .offerInformation .order-bumb-info p {
      font-size: 14px;
      font-weight: 700;
      letter-spacing: -.1px;
      margin-left: .25rem
    }

    .order-bump-content .offerInformation .order-bumb-info .fakePrice {
      color: #ef4444;
      color: var(--bs-danger);
      font-size: 14px;
      font-weight: 700;
      -webkit-text-decoration: line-through;
      text-decoration: line-through
    }

    .order-bump-content .offerInformation .order-bumb-info p strong {
      font-size: inherit;
      font-weight: 700
    }

    .contentCheckoutAmount h4 {
      color: #029b4b;
      font-size: 16px;
      font-weight: 700;
      margin-top: 1.5rem
    }

    .contentCheckoutAmount p {
      color: #878a9b;
      font-size: 14px;
      margin-top: .5rem
    }

    .submitCheckoutButton {
      -webkit-font-smoothing: auto;
      background-color: #03d952;
      border: 1px solid transparent;
      border-radius: 6px;
      box-shadow: inset 0 -4px 0 0 rgba(0, 0, 0, .133);
      color: #fff;
      font-weight: 700;
      letter-spacing: .25px;
      line-height: 2;
      margin-top: 2rem;
      padding: .785rem 2rem .9rem;
      text-align: center;
      -webkit-text-decoration: none;
      text-transform: uppercase;
      transition: all .6s cubic-bezier(.2, 1, .22, 1);
      -moz-user-select: none;
      width: 100%
    }

    .submitCheckoutButton:hover {
      background-color: #00ba45;
      transition: all .3s ease
    }

    .submitCheckoutButton:disabled {
      opacity: .6
    }

    #footerText {
      color: #999;
      display: inline-flex;
      font-size: 12px;
      font-weight: 400;
      margin-top: 1.5rem;
      width: 100%
    }

    #footerText,
    footer {
      align-items: center;
      justify-content: center;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none
    }

    footer {
      display: flex;
      flex-direction: column;
      gap: 1.5rem;
      margin: 2.5rem 0
    }

    footer h5 {
      color: #7c7c7c;
      display: flex;
      flex-wrap: wrap;
      font-size: 1rem;
      font-weight: 600;
      gap: 1rem;
      justify-content: center;
      letter-spacing: -.3px
    }

    footer h5 span {
      font-size: inherit;
      font-weight: inherit;
      white-space: nowrap
    }

    footer p {
      color: #999;
      font-size: 12px;
      font-weight: 500;
      text-align: center;
      width: 100%
    }

    footer p strong {
      display: block;
      font-size: inherit;
      font-weight: 600
    }

    .whatsappButton {
      background-color: #08be4b;
      background-color: var(--green-success);
      background-image: url(/_nuxt/img/2e4dd3b.svg);
      background-position: 50%;
      background-repeat: no-repeat;
      background-size: 22px;
      border-color: #08be4b;
      border-color: var(--green-success);
      border-radius: 50%;
      bottom: 1rem;
      box-shadow: 0 .3rem 1.525rem -.375rem rgba(19, 16, 34, .1), 0 .25rem .8125rem -.125rem rgba(19, 16, 34, .06) !important;
      cursor: pointer;
      display: block;
      height: 3.25rem;
      position: fixed;
      right: 1rem;
      -webkit-text-decoration: none;
      text-decoration: none;
      transition: .2s;
      width: 3.25rem
    }

    .input-wrapper .no-valid-icon.padlock-icon input:invalid {
      background-image: none
    }



    .loaderSpinner {
      border: 2px solid #fff;
      border-radius: 50%;
      border-right-color: transparent;
      height: 20px;
      width: 20px
    }

    .congratulation-content .payLoader .loaderSpinner,
    .loaderSpinner {
      animation: loaderSpinner .75s linear infinite;
      display: inline-block;
      vertical-align: -.125em
    }

    .congratulation-content .payLoader .loaderSpinner {
      border: .15em solid #08be4b;
      border-color: var(--green-success);
      border-radius: 50%;
      border-right-color: transparent;
      border-width: .2rem;
      height: 3.5rem;
      width: 3.5rem
    }

    @keyframes loaderSpinner {
      to {
        transform: rotate(1turn)
      }
    }

    .submitCheckoutButton {
      align-items: center;
      display: flex;
      gap: .5rem;
      justify-content: center
    }

    .alertModal {
      background-color: #fff;
      background-color: var(--white);
      border-radius: .5rem;
      box-shadow: 0 .275rem 1.25rem rgba(19, 16, 34, .05), 0 .25rem .5625rem rgba(19, 16, 34, .03);
      left: 50%;
      max-width: 500px;
      padding: 0 1.5rem 1.5rem;
      position: fixed;
      top: 50%;
      transform: translate(-50%, -50%);
      z-index: 3
    }

    .alertModal .modal-header {
      align-items: center;
      justify-content: space-between
    }

    .alertModal .modal-header h2 {
      border-bottom: 1px solid #e2e5f1;
      color: #ef4444;
      color: var(--red);
      font-size: 1.25rem;
      padding: 1.125rem 0
    }

    .alertModal .modal-body p {
      margin-top: 1rem;
      text-align: center
    }

    .alertModal button {
      align-items: center;
      background-color: #4c82f7;
      background-color: var(--blue);
      border-radius: .5rem;
      color: #fff;
      color: var(--white);
      cursor: pointer;
      font-size: 1rem;
      font-weight: 700;
      justify-content: center;
      margin-top: 1.5rem;
      padding: .785rem 2rem;
      width: 100%
    }

    .alertModal button:hover {
      background-color: #2768f5
    }

    .overlay {
      background-color: #000;
      cursor: pointer;
      height: 100vh;
      left: 0;
      opacity: .65;
      position: fixed;
      top: 0;
      width: 100%;
      z-index: 2
    }

    .tab-content h3 {
      align-items: center;
      display: flex;
      gap: .5rem
    }

    .inherit {
      font-size: inherit;
      font-weight: inherit
    }

    .tab-content h3 img {
      filter: hue-rotate(-40deg) brightness(.9) !important
    }

      main {
        margin-top: 30px
      }

      .content-wrapper {
        padding: .5rem 1rem 1rem
      }

      .content-wrapper.secondary {
        padding: 1.5rem .9rem
      }

      .content-wrapper .contentProductData .infoProduct h4 {
        font-size: 14px
      }

      .content-wrapper .image-content {
        height: 75px;
        width: 75px
      }

      .tab-header .tab-button {
        font-size: .825rem;
        padding: .5rem;
        text-align: center;
        width: 33.3333333333%
      }


      .tab-content .containerInputs.creditCardData .input-wrapper input {
        padding: .5rem .7rem
      }

      .tab-content .containerInputs.creditCardData .input-wrapper .dropdownButton:after {
        right: .7rem;
        width: 12px
      }

      .order-bump-content .titleContentBump {
        font-size: 14px
      }

      .order-bump-content .offerInformation {
        gap: .4rem;
        padding: 1rem .5rem 1.5rem
      }

      .order-bump-content .offerInformation p {
        color: #555;
        font-weight: 700;
        letter-spacing: -.1px
      }

      .creditCardData .padlock-icon:before {
        display: none
      }

      /* Estilos para seleção de parcelas */
      #installmentCount {
        width: 100%;
        padding: 12px;
        border: 1px solid #ddd;
        border-radius: 5px;
        font-size: 16px;
        background-color: #fff;
        cursor: pointer;
      }

      #installmentCount:focus {
        outline: none;
        border-color: #0d6efd;
        box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
      }

      #installmentInfo {
        border-left: 4px solid #0d6efd;
        font-size: 14px;
        line-height: 1.4;
      }

      #installmentInfo strong {
        color: #0d6efd;
      }

      .checkbox-content input[type=checkbox] {
        align-self: start;
        font-size: .8rem;
        margin-top: 2.3px;
        min-width: 16px
      }



      @media screen and (max-width:550px) {
        header {
          gap: .5rem;
          justify-content: space-between
        }

        header h2 {
          font-size: 1.5rem
        }

        header p {
          font-size: 14px
        }


        .tab-content .containerInputs.creditCardData .input-wrapper {
          width: 25%
        }

        .tab-content .containerInputs.creditCardData .input-wrapper:last-child {
          width: 50% !important
        }
      }
    

    .text-success {
      color: #0f8329;
      color: var(--green-1)
    }
  </style>
  <style type="text/css">
    header[data-v-6f858b42] {
      background-color: var(--white);
      padding: 30px;
      position: sticky
    }

    @media screen and (max-width:995px) {
      header[data-v-6f858b42] {
        justify-content: center
      }
    }
  </style>
  <style type="text/css">
    footer a[data-v-b81dc4f2] {
      font-size: inherit;
      opacity: 1;
      -webkit-text-decoration: none;
      text-decoration: none
    }

    footer a[data-v-b81dc4f2]:hover {
      opacity: .8;
      -webkit-text-decoration: underline;
      text-decoration: underline
    }

    footer[data-v-b81dc4f2] {
      align-items: center;
      flex-direction: column;
      gap: 1.5rem;
      margin: 2.5rem 0;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none
    }

    footer[data-v-b81dc4f2],
    footer h5[data-v-b81dc4f2] {
      display: flex;
      justify-content: center
    }

    footer h5[data-v-b81dc4f2] {
      color: #7c7c7c;
      flex-wrap: wrap;
      font-size: 1rem;
      font-weight: 600;
      gap: 1rem;
      letter-spacing: -.3px
    }

    footer h5 span[data-v-b81dc4f2] {
      font-size: inherit;
      font-weight: inherit;
      white-space: nowrap
    }

    footer p[data-v-b81dc4f2] {
      color: #999;
      font-size: 12px;
      font-weight: 500;
      text-align: center;
      width: 100%
    }

    footer p strong[data-v-b81dc4f2] {
      display: block;
      font-size: inherit;
      font-weight: 600
    }

    @media screen and (max-width:995px) {
      footer[data-v-b81dc4f2] {
        margin: 60px auto
      }
    }
  </style>
  <style type="text/css">
    .backgroundBanner[data-v-24d558e9] {
      filter: blur(15px);
      height: 60vh;
      left: 0;
      -o-object-fit: cover;
      object-fit: cover;
      -o-object-position: center center;
      object-position: center center;
      opacity: .75;
      position: absolute;
      top: -5rem;
      width: 100%;
      z-index: -1
    }

    .backgroundBanner[data-v-24d558e9]:after {
      background-image: linear-gradient(0deg, #ececec, transparent 40%);
      background-size: 100%;
      content: "";
      height: 100%;
      position: absolute;
      width: 100%
    }
  </style>
  <style type="text/css">
    svg[data-v-41f15b78] {
      min-height: 40px;
      min-width: 40px;
      width: 40px
    }
  </style>
  <style type="text/css">
    footer a[data-v-406b1e0c] {
      font-size: inherit;
      opacity: 1;
      -webkit-text-decoration: none;
      text-decoration: none
    }

    footer a[data-v-406b1e0c]:hover {
      opacity: .8;
      -webkit-text-decoration: underline;
      text-decoration: underline
    }

    footer[data-v-406b1e0c] {
      align-items: center;
      flex-direction: column;
      gap: 1.5rem;
      margin: 2.5rem 0;
      -webkit-user-select: none;
      -moz-user-select: none;
      user-select: none
    }

    footer[data-v-406b1e0c],
    footer h5[data-v-406b1e0c] {
      display: flex;
      justify-content: center
    }

    footer h5[data-v-406b1e0c] {
      color: #7c7c7c;
      flex-wrap: wrap;
      font-size: 1rem;
      font-weight: 600;
      gap: 1rem;
      letter-spacing: -.3px
    }

    footer h5 span[data-v-406b1e0c] {
      font-size: inherit;
      font-weight: inherit;
      white-space: nowrap
    }

    footer p[data-v-406b1e0c] {
      color: #999;
      font-size: 12px;
      font-weight: 500;
      text-align: center;
      width: 100%
    }

    footer p strong[data-v-406b1e0c] {
      display: block;
      font-size: inherit;
      font-weight: 600
    }
  </style>
  <style type="text/css">
    .checkout-preloader[data-v-9420208a] {
      align-items: center;
      background-color: var(--white);
      background-size: 35px;
      display: flex;
      flex-direction: column;
      height: 100vh;
      justify-content: center;
      left: 0;
      overflow: hidden;
      position: fixed;
      top: 0;
      width: 100vw;
      z-index: 9999
    }

    .checkout-preloader svg[data-v-9420208a] {
      height: 33px;
      left: 50%;
      position: absolute;
      top: 50%;
      transform: translate(-50%, -50%);
      width: 33px
    }

    .checkout-preloader[data-v-9420208a]:before {
      animation: spin-9420208a .9s linear infinite;
      -webkit-animation: spin-9420208a .9s linear infinite;
      border-left: 2px solid #e8464e;
      border-radius: 50%;
      border-right: 2px solid rgba(232, 70, 78, 0);
      border-top: 2px solid transparent;
      content: "";
      display: inline-block;
      height: 72px;
      width: 72px
    }

    @keyframes spin-9420208a {
      to {
        -webkit-transform: rotate(1turn)
      }
    }
  </style>
  <link data-n-head="1" rel="preconnect" href="https://www.googletagmanager.com/">
  <link data-n-head="1" rel="preconnect" href="https://www.google-analytics.com/">
  <meta data-n-head="1" name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <!-- ALERTA CUSTOMIZADO -->

  <?php if (!empty($googleSnippetCode)): ?>
  <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo htmlspecialchars($googleSnippetCode); ?>"></script>
  <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());
    gtag('config', '<?php echo htmlspecialchars($googleSnippetCode); ?>');
  </script>
  <?php endif; ?>

  <script>
    // Variáveis PHP para JavaScript
    var META_PIXEL_ID = '<?php echo $metaPixel; ?>';
    var META_ACCESS_TOKEN = '<?php echo $metaAccessToken; ?>';
    var GOOGLE_SNIPPET_CODE = '<?php echo $googleSnippetCode; ?>';
    var GOOGLE_LABEL = '<?php echo $googleLabel; ?>';
    var PRODUCT_VALUE = <?php echo isset($row['valor']) ? (float)$row['valor'] : 0; ?>;
    var PRODUCT_NAME = '<?php echo isset($row['name_produto']) ? htmlspecialchars($row['name_produto']) : ''; ?>';
    var USER_EMAIL = '<?php echo isset($row['email']) ? htmlspecialchars($row['email']) : ''; ?>';

  </script>

</head>

<body cz-shortcut-listen="true">
  <div id="__nuxt">
    <div id="__layout">

      <script>
        function startCountdown(duration) {
          const display = document.getElementById('countdown');
          let timer = duration, minutes, seconds;

          function updateDisplay() {
            minutes = Math.floor(timer / 60);
            seconds = timer % 60;

            // Adiciona zeros à esquerda, se necessário
            minutes = minutes < 10 ? '0' + minutes : minutes;
            seconds = seconds < 10 ? '0' + seconds : seconds;

            display.textContent = '00:' + minutes + ':' + seconds;

            if (--timer < 0) {
              timer = duration; // Reinicia o timer se necessário
            }
          }

          // Atualiza a cada segundo
          setInterval(updateDisplay, 1000);
          updateDisplay(); // Atualiza imediatamente
        }

        window.onload = function () {
          const fiveMinutes = 60 * 5; // 5 minutos em segundos
          startCountdown(fiveMinutes);
        };
      </script>

      <div data-v-24d558e9="">

        <header data-v-24d558e9="" style="background-color: rgb(0, 0, 13);">
          <h2 id="countdown" data-v-24d558e9="" style="color: rgb(255, 255, 255);">
            00:05:00
          </h2>
          <svg data-v-41f15b78="" data-v-24d558e9="" viewBox="0 0 512.000000 512.000000" style="fill: rgb(255, 0, 0);">
            <g data-v-41f15b78="" transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" stroke="none">
              <path data-v-41f15b78=""
                d="M2651 5004 c-69 -19 -108 -43 -161 -100 -136 -148 -114 -380 48 -499 26 -19 64 -40 85 -47 l37 -11 0 -127 0 -127 -72 -18 c-233 -56 -514 -194 -723 -354 -76 -58 -243 -218 -308 -296 l-50 -60 -383 -5 -382 -5 -26 -24 c-50 -48 -39 -133 21 -160 16 -7 129 -11 323 -11 165 0 300 -2 300 -4 0 -2 -24 -50 -54 -107 -29 -57 -68 -143 -86 -191 l-33 -88 -563 0 -563 0 -26 -22 c-34 -30 -44 -88 -20 -124 35 -53 41 -54 601 -54 l516 0 -6 -22 c-7 -27 -33 -217 -42 -300 l-5 -58 -230 0 c-250 0 -274 -4 -297 -55 -15 -33 -15 -57 0 -90 23 -51 47 -55 301 -55 l234 0 7 -80 c6 -77 42 -275 52 -292 3 -4 -141 -8 -321 -8 -353 0 -377 -3 -410 -54 -24 -36 -14 -94 20 -124 26 -22 27 -22 401 -22 l375 0 11 -32 c20 -58 115 -244 168 -329 194 -313 487 -575 825 -739 491 -239 1018 -271 1550 -95 87 29 331 145 408 195 81 52 96 124 35 175 -40 34 -83 32 -143 -6 -94 -60 -265 -140 -382 -179 -540 -179 -1129 -100 -1598 215 -748 503 -1014 1475 -626 2290 248 520 710 879 1291 1002 114 25 145 27 350 27 206 0 236 -2 351 -27 183 -39 296 -78 464 -162 168 -84 286 -164 417 -285 628 -579 769 -1532 334 -2263 -55 -94 -62 -118 -46 -158 21 -49 93 -74 141 -49 25 14 77 97 143 228 342 83 271 1498 -185 2112 -77 104 -247 281 -349 363 -214 173 -482 310 -743 379 l-87 23 0 125 0 125 56 24 c71 31 139 97 172 169 37 81 38 193 0 273 -36 79 -89 133 -166 171 l-67 33 -415 2 c-341 2 -425 0 -469 -13z m839 -190 c43 -9 97 -65 106 -108 8 -46 -10 -96 -47 -132 l-30 -29 -410 -3 c-399 -3 -412 -2 -444 18 -64 39 -84 129 -42 191 45 68 49 69 463 69 204 0 386 -3 404 -6z m-150 -576 l0 -103 -240 0 -240 0 0 103 0 102 240 0 240 0 0 -102z">
              </path>
              <path data-v-41f15b78=""
                d="M2910 3663 c-207 -33 -359 -81 -520 -164 -419 -216 -710 -601 -812 -1073 -32 -148 -32 -455 1 -606 90 -422 331 -774 686 -1002 507 -326 1163 -326 1670 0 355 228 596 580 686 1002 33 151 33 458 1 606 -138 637 -632 1117 -1260 1225 -106 18 -372 25 -452 12z m405 -208 c584 -96 1030 -550 1121 -1140 19 -121 14 -343 -10 -455 -59 -273 -180 -496 -375 -690 -198 -197 -414 -314 -684 -371 -135 -29 -380 -32 -510 -6 -187 38 -372 115 -527 220 -41 29 -123 99 -181 157 -195 194 -316 417 -375 690 -24 112 -29 334 -10 455 90 586 537 1043 1115 1140 106 18 328 18 436 0z">
              </path>
              <path data-v-41f15b78=""
                d="M3051 3276 c-37 -20 -50 -55 -51 -129 0 -76 17 -118 57 -136 32 -15 59 -14 92 3 38 20 51 55 51 142 0 70 -2 78 -29 105 -33 32 -78 38 -120 15z">
              </path>
              <path data-v-41f15b78=""
                d="M3765 2916 c-16 -8 -142 -127 -279 -264 l-249 -250 -40 14 c-49 17 -150 17 -197 -1 l-35 -13 -126 124 c-116 114 -129 124 -163 124 -48 0 -72 -13 -91 -50 -31 -60 -24 -74 110 -209 l124 -126 -14 -49 c-32 -106 -8 -216 66 -299 120 -137 338 -137 458 0 74 83 98 193 66 299 l-15 49 260 260 c255 256 260 262 260 302 0 30 -7 47 -26 67 -15 14 -32 26 -40 26 -7 0 -18 2 -26 5 -7 2 -26 -2 -43 -9z m-589 -720 c40 -40 45 -83 15 -132 -57 -93 -201 -47 -201 65 0 51 54 101 110 101 34 0 48 -6 76 -34z">
              </path>
              <path data-v-41f15b78=""
                d="M1965 2196 c-46 -46 -43 -112 7 -149 29 -22 108 -33 161 -23 84 16 116 108 58 167 -28 28 -34 29 -116 29 -78 0 -88 -2 -110 -24z">
              </path>
              <path data-v-41f15b78=""
                d="M4009 2191 c-21 -22 -29 -39 -29 -66 0 -79 45 -109 158 -103 69 3 76 6 103 36 31 35 36 66 17 107 -18 40 -57 55 -143 55 -71 0 -79 -2 -106 -29z">
              </path>
              <path data-v-41f15b78=""
                d="M3073 1243 c-12 -2 -34 -18 -48 -34 -22 -27 -25 -40 -25 -110 0 -73 2 -81 29 -111 33 -37 82 -43 125 -14 35 22 46 53 46 126 0 32 -4 70 -10 84 -15 40 -70 68 -117 59z">
              </path>
              <path data-v-41f15b78="" d="M63 1595 c-99 -43 -71 -185 36 -185 96 0 138 124 59 173 -37 24 -61 27 -95 12z">
              </path>
              <path data-v-41f15b78=""
                d="M4389 831 c-38 -39 -39 -87 -3 -130 21 -26 33 -31 68 -31 49 0 79 18 96 59 40 98 -85 177 -161 102z">
              </path>
            </g>
          </svg>
          <p data-v-24d558e9="" style="color: rgb(255, 255, 255);">
            Sua compra está reservada!
          </p>
          <div data-v-24d558e9="" class="progressBar" style="background-color: rgb(130, 9, 3);"><span data-v-24d558e9=""
              class="bar" style="width: 95%; background-color: rgb(9, 236, 96);"></span></div>
        </header>
        <main data-v-24d558e9="">


          <div data-v-24d558e9="" class="bannerImage" style="">
            <?php if (!empty($row['banner_produto'])): ?>
              <img data-v-24d558e9="" fetchpriority="high" rel="preload" alt="Banner image"
                src="../../<?php echo htmlspecialchars($row['banner_produto']); ?>">
            <?php endif; ?>
          </div>


          <div data-v-24d558e9="" class="content-wrapper">
            <h5 data-v-24d558e9="">VOCÊ ESTÁ ADQUIRINDO:</h5>
            <div data-v-24d558e9="" class="contentProductData">
              <div data-v-24d558e9="" class="image-content"><img data-v-24d558e9="" alt="imagem do produto"
                  fetchpriority="high" rel="preload" src="../../<?php echo htmlspecialchars($row['logo_produto']); ?>"
                  style=""></div>
              <div data-v-24d558e9="" class="infoProduct">
                <h4 data-v-24d558e9=""><?php echo htmlspecialchars($row['name_produto']); ?></h4> <span
                  data-v-24d558e9="">

                  <h3 data-v-24d558e9="">
                    <?php echo "RS " . safe_number_format($row['valor'], 2, ',', '.'); ?>
                  </h3>
                </span>
              </div>
            </div>
          </div>



          <style>
            h1 {
              color: #333;
            }


            label {
              display: block;
              margin-bottom: 5px;
            }

            input[type="text"] {
              margin-top: 10px;
              border-radius: 6px;
              width: 100%;
              padding: 10px;
              margin-bottom: 10px;
            }

            select{
              margin-top: 10px;
              border-radius: 6px;
              width: 100%;
              padding: 10px;
              margin-bottom: 10px;
            }


            .divqr {
              align-items: center;
              padding: 20px;
              display: inline-grid;

            }

            .container3 {
              display: flex;
              justify-content: center;
              align-items: center;
              height: 100vh;
            }

            #qrcode {
              padding: 10px;
              border-radius: 10px;
            }


            #qr-code-text {
              font-size: 10px;
              margin-bottom: 10px;
              border-radius: 6px;
              background-color: #e4e2e200;
              border: 1px solid #b4b4b4;
              padding: 4px;
              word-break: break-all;
              max-width: 300px;

            }

            #copy-button-pix {

              background-color: #3166e0;
              border-radius: 6px;
              color: #fafafa;
              font-weight: bold;
              font-size: 16;
              padding: 8px 20px;
              border: none;
              cursor: pointer;
              margin-top: 10px;
              animation: pulse 2s infinite;
              margin: 0 auto;

            }

            .redirectButton {
              background-color: #5a9759;
              border-radius: 6px;
              color: #fff;
              padding: 10px 120px;
              border: none;
              cursor: pointer;
              margin-top: 15px;

            }


            .conteiner {
              display: flex;
              justify-content: center;
              margin-top: 0.4rem;
              flex-wrap: wrap;
            }

            .conteiner label {
              display: flex;
              margin-top: 0.9rem;
              flex-direction: column;
            }

            .conteiner form {
              flex-grow: 1;
            }

            .conteiner input:disabled {
              color: #9d9d9d
            }

            .conteiner input {
              border-radius: 0.4rem;
              background: #263043;
            }
          </style>


          <div data-v-24d558e9="" class="content-wrapper secondary">

            <div class="box1" style="display: none;">








            </div>


            <div id="apiResponse" style="display: none;"></div>

            <div class="properties">
              <form data-v-24d558e9="">
                <h2 data-v-24d558e9="">
                  <span data-v-24d558e9="" class="orderNumber">1</span> Dados pessoais
                </h2>
                <div data-v-24d558e9="" class="input-wrapper">
                  <label data-v-24d558e9="" for="userName">NOME
                    COMPLETO</label>
                  <div data-v-24d558e9="" class="input-icons user-icon">
                    <input data-v-24d558e9="" type="text" inputmode="text" id="name" name="name" class="">
                  </div>

                  <span data-v-24d558e9="" class="alertText" style="display: none;">
                  </span>
                </div>
                <div data-v-24d558e9="" class="input-wrapper">
                  <label data-v-24d558e9="" for="yourEmail">Seu e-mail</label>
                  <div data-v-24d558e9="" class="input-icons email-icon">
                    <input data-v-24d558e9="" type="email" inputmode="text" name="yourEmail" class="">
                  </div> <span data-v-24d558e9="" class="alertText" style="display: none;">
                  </span>
                </div>
                <div data-v-24d558e9="" class="containerInputs">
                  <div data-v-24d558e9="" class="input-wrapper">
                    <label data-v-24d558e9="" for="userDocument">CPF</label>
                    <div data-v-24d558e9="" class="input-icons padlock-icon">
                      <input data-v-24d558e9="" type="tel" inputmode="tel" id="document" name="document"
                        autocomplete="on" class="">
                    </div>
                    <span data-v-24d558e9="" class="alertText" style="display: none;">Digite um documento válido.</span>
                  </div>
                  <div data-v-24d558e9="" class="input-wrapper">
                    <label data-v-24d558e9="" for="telefone">CELULAR COM WHATSAPP</label>
                    <div data-v-24d558e9="" class="input-icons phone-icon">
                      <input data-v-24d558e9="" type="tel" inputmode="tel" id="telefone" name="telefone" class="">
                    </div>
                    <span data-v-24d558e9="" class="alertText" style="display: none;"></span>
                  </div>
                </div>
                <?php
                // Certifique-se de que $row['valor'] é um valor numérico
                $valor = safe_number_format($row['valor'], 2, ',', '.');
                ?>
                <div class="valor" style="display: none;">
                  <input type="text" value="<?php echo htmlspecialchars($valor); ?>"
                    placeholder="<?php echo htmlspecialchars($valor); ?>" readonly id="valuedeposit">
                </div>
            </div>
            <h2 data-v-24d558e9=""><span data-v-24d558e9="" class="orderNumber">2</span> DADOS DE PAGAMENTO</h2>

            <!-- Tabs de seleção de pagamento -->
            <div class="tab-header">
              <button type="button" class="tab-button active" id="btnPix" onclick="selectPayment('PIX')">PIX</button>
              <button type="button" class="tab-button" id="btnCard" onclick="selectPayment('CREDIT_CARD')">Cartão de
                Crédito</button>
            </div>

            <!-- Opção Pix -->
            <div id="pixOption" class="tab-content">
              <h4>Pague no PIX</h4>
              <p>Ao selecionar a opção Gerar Pix o código para pagamento estará disponível.</p>
            </div>

            <!-- Opção Cartão -->
            <div id="cardOption" class="tab-content" style="display:none;">
              <h4>Pague com Cartão de Crédito</h4>
              
              <!-- Seleção de Parcelas -->
              <div class="input-wrapper">
                <label for="installmentCount">Parcelas</label>
                <select id="installmentCount" onchange="updateInstallmentInfo()">
                  <option value="1">À vista (1x)</option>
                  <?php
                  $max_parcelas = isset($row['max_parcelas']) ? intval($row['max_parcelas']) : 1;
                  $parcelavel = isset($row['parcelavel']) ? intval($row['parcelavel']) : 0;
                  
                  if ($parcelavel == 1 && $max_parcelas > 1) {
                    for ($i = 2; $i <= $max_parcelas; $i++) {
                      echo "<option value=\"{$i}\">{$i}x sem juros</option>";
                    }
                  }
                  ?>
                </select>
              </div>
              
              <!-- Informações do Parcelamento -->
              <div id="installmentInfo" style="display: none; background: #f8f9fa; padding: 10px; border-radius: 5px; margin-bottom: 15px;">
                <small id="installmentDetails"></small>
              </div>
              
              <div class="input-wrapper">
                <label for="cardNumber">Número do Cartão</label>
                <input type="text" id="cardNumber" maxlength="19" placeholder="0000 0000 0000 0000">
              </div>
              <div class="input-wrapper">
                <label for="cardName">Nome impresso no Cartão</label>
                <input type="text" id="cardName" placeholder="Nome completo">
              </div>
              <div class="input-wrapper">
                <label for="cardExpiry">Validade (MM/AA)</label>
                <input type="text" id="cardExpiry" maxlength="5" placeholder="MM/AA">
              </div>
              <div class="input-wrapper">
                <label for="cardCvv">CVV</label>
                <input type="text" id="cardCvv" maxlength="4" placeholder="CVV">
              </div>
              <div class="input-wrapper">
                <label for="cardCep">CEP do titular do cartão</label>
                <input type="text" id="cardCep" maxlength="9" placeholder="00000-000">
              </div>
              <div class="input-wrapper">
                <label for="endereco">Endereço </label>
                <input type="text" id="endereco" maxlength="9" placeholder="00000-000">
              </div>
              <div class="input-wrapper">
                <label for="numero_endereco">Número </label>
                <input type="text" id="numero_endereco" maxlength="9" placeholder="00000-000">
              </div>
              <div class="input-wrapper">
                <label for="cardCity">Cidade do titular do cartão</label>
                <input type="text" id="cardCity" maxlength="50" placeholder="Cidade">
              </div>
              <div class="input-wrapper">
                <label for="cardState">Estado do titular do cartão</label>
                <input type="text" id="cardState" maxlength="2" placeholder="UF">
              </div>
            </div>

            <div class="contentCheckoutAmount">
              <h4>Valor total: <?php echo "RS " . safe_number_format($row['valor'], 2, ',', '.'); ?></h4>
              <div id="loadingSpinner" class="loading-spinner"></div>
            </div>
            <button type="button" onclick="enviarPagamento()" class="submitCheckoutButton" id="submitButton">
              <span class="inherit">Comprar e receber agora</span>
            </button>

            <!-- QR Code e instruções Pix: agora logo abaixo do botão -->
            <div class="box1" style="display: none; margin-top: 2rem;">
              <h2 data-v-4dd5f040="">
                Siga os passos para pagar:
              </h2>
              <p data-v-4dd5f040=""><span data-v-4dd5f040="" class="numberIcon">1 - </span>Copie o código <strong
                  data-v-4dd5f040="">PIX:</strong></p>
              <div class="conteiner">
                <div id="qrcode"></div>
                <div class="divqr">
                  <div id="qr-code-text"></div>
                  <button id="copy-button-pix">Copiar Código Pix</button>
                </div>
              </div>
              <br>
              <p data-v-4dd5f040=""><span data-v-4dd5f040="" class="numberIcon">2 - </span>Abra o aplicativo do seu
                banco favorito</p>
              <p data-v-4dd5f040=""><span data-v-4dd5f040="" class="numberIcon">3 - </span>Na seção de PIX, selecione a
                opção <strong data-v-4dd5f040="">"Pix Copia e Cola"</strong></p>
              <p data-v-4dd5f040=""><span data-v-4dd5f040="" class="numberIcon">4 - </span>Cole o código</p>
              <p data-v-4dd5f040=""><span data-v-4dd5f040="" class="numberIcon">5 - </span>Confirme o pagamento</p>
            </div>
            </form>
          </div>







          <div class="url-api" style="display: none;">
            <input type="text" placeholder="URL de Requisição" id="apiUrl" value="https://api.berapay.com.br/v1/gateway/">
          </div>

          <div class="chave-api" style="display: none;">
            <input type="text" placeholder="Chave key" id="user_id"
              value="<?php echo htmlspecialchars($row['user_id']); ?>">
          </div>

      </div>





      <p data-v-24d558e9="" id="footerText">Ambiente criptografado e 100% seguro.</p>
    </div>
    </main>
    <footer data-v-406b1e0c="" data-v-24d558e9="">
      <h5 data-v-406b1e0c=""><span data-v-406b1e0c="" class="grey-padlock-icon">Compra segura</span> <span
          data-v-406b1e0c="" class="safe-icon">Dados protegidos</span></h5>
      <p data-v-406b1e0c="">
        © 2024 - Todos os
        direitos reservados.
      </p>
    </footer>
    <!----> <!---->
    <div data-v-9420208a="" data-v-24d558e9="" class="checkout-preloader" style="display: none;"><svg data-v-9420208a=""
        width="21" height="24" viewBox="0 0 21 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path data-v-9420208a=""
          d="M5.27128 21.4966C5.29592 21.5102 5.32179 21.5239 5.34642 21.5363C6.10034 21.9324 6.91954 22.2193 7.7794 22.3795L7.9149 22.4242V22.6291C7.9149 23.3866 8.52345 24 9.2749 24H12.0491V22.2466C14.1137 21.7747 16.0072 20.7167 17.5236 19.1595C19.5821 17.0448 20.7166 14.2483 20.7166 11.2866C20.7166 8.32245 19.5833 5.52719 17.5236 3.41243C15.47 1.30015 12.7217 0.10431 9.78983 0.0447043L7.51208 0V5.01557C4.49766 5.67745 2.02773 7.90397 1.04961 10.8545C1.03729 10.8594 1.02621 10.8631 1.01512 10.8694C0.744106 11.7262 0.599976 12.6377 0.599976 13.5851C0.599976 17.0025 2.48969 19.9729 5.27128 21.4966ZM5.09389 13.1356C5.2257 12.0466 5.75171 11.0916 6.51795 10.4087C7.27802 9.73312 8.27215 9.32457 9.35251 9.31588C10.0337 9.31091 10.699 9.05635 11.188 8.57826C11.6968 8.08154 11.9777 7.41346 11.9777 6.70068V5.0044C14.4698 5.98913 16.2486 8.44911 16.2486 11.2841C16.2486 14.8331 13.4596 17.7936 9.96722 18.0109L9.95121 18.0034L9.42396 18.0233L9.11476 18.0171C8.9694 18.0084 8.82527 17.9922 8.6836 17.9686L8.60968 17.9562C6.86287 17.6408 5.47085 16.2587 5.137 14.4954L5.11114 14.36C5.04338 14.0011 5.03106 13.6336 5.07418 13.271L5.09019 13.1356H5.09389Z"
          fill="#E02932"></path>
      </svg></div>
  </div>
  </div>
  </div>



  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4"
    crossorigin="anonymous"></script>
  <script src="../js/confetti.min.js"></script>
  <script>
    confetti.start();
    setTimeout(function () {
      confetti.stop();
    }, 8000);
  </script>
  <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
  <script>
    var paymentCode;
    var transactionId;
    // Adquirente atual (ajuste aqui para mudar o provedor: ex. 'asaas', 'pagarme', etc.)
    var adquirente = 'asaas';

    async function generateQRCode() {
      var name = document.getElementById('name').value;
      var emailEl = document.getElementsByName('yourEmail')[0];
      var email = emailEl ? emailEl.value : '';
      var cpf = document.getElementById('document').value;
    var amount = document.getElementById('valuedeposit').value;
    // Normaliza valores pt-BR ("3,33") para formato numérico com ponto
    var normalizedAmount = amount.replace(/\./g, '').replace(/,/g, '.');
      var apiUrl = document.getElementById('apiUrl').value;
      var user_id = document.getElementById('user_id').value;

      var payload = {
        "api-key": user_id,
        "requestNumber": "12356",
        "dueDate": "2023-12-31",
        "amount": parseFloat(normalizedAmount),
        "client": {
          "name": name,
          "document": cpf,
          "email": email
        }
      };

      try {
        const response = await fetch(apiUrl, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(payload)
        });

        const data = await response.json();
        document.getElementById('apiResponse').innerHTML = JSON.stringify(data);

        if (data.paymentCode) {
          paymentCode = data.paymentCode;
          transactionId = data.idTransaction; // Ajustado para pegar idTransaction



          // Adiciona o paymentCode ao texto da div
          document.getElementById('qr-code-text').textContent = paymentCode;

          document.querySelectorAll('.properties').forEach(function (element) {
            element.style.display = 'none';
          });
          document.querySelectorAll('.box1').forEach(function (element) {
            element.style.display = 'block';
          });

          var qrcode = new QRCode(document.getElementById('qrcode'), {
            text: data.paymentCode,
            width: 256,
            height: 256
          });

          document.getElementById('qrcode').style.display = 'block';



          // Inicia a verificação do pagamento a cada 2 segundos
          if (window.pixStatusInterval) {
            clearInterval(window.pixStatusInterval);
          }
          window.pixStatusInterval = setInterval(checkPaymentStatus, 2000);
        } else {
          console.error("Erro na solicitação:", data.message);
        }
      } catch (error) {
        console.error("Erro na solicitação:", error);
      }
    }

    async function checkPaymentStatus() {
      var apiUrl = `https://api.berapay.com.br/v1/webhook/${adquirente}.php?id=${transactionId}`;//CRIPTOGRAFE O ID
 

      try {
        const response = await fetch(apiUrl, {
          method: "POST",
          headers: {
            "Content-Type": "application/json",
          },
          body: JSON.stringify(transactionId)
        });

        const data = await response.json();
        document.getElementById('apiResponse').innerHTML = JSON.stringify(data);

        // Alguns webhooks retornam { status: "no_change", current_status: "PAID_OUT" }
        // Uniformiza a checagem priorizando current_status quando existir
        const status = String((data && (data.current_status || data.status)) || '').toUpperCase();

        if (status === "PAID_OUT") {
          if (window.pixStatusInterval) {
            clearInterval(window.pixStatusInterval);
            window.pixStatusInterval = null;
          }

          // Integração com Meta Ads (Facebook Pixel)
          if (META_PIXEL_ID && META_ACCESS_TOKEN) {
            try {
              const metaResponse = await fetch('/integracoes/process_meta_conversion.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({
                  meta_pixel_id: META_PIXEL_ID,
                  meta_access_token: META_ACCESS_TOKEN,
                  value: PRODUCT_VALUE,
                  currency: 'BRL',
                  event_name: 'Purchase',
                  event_source_url: window.location.href,
                  user_email: USER_EMAIL,
                })
              });
              const metaData = await metaResponse.json();
              if (metaData.success) {
                console.log('Evento Meta Ads enviado com sucesso (PIX):', metaData.response);
              } else {
                console.error('Erro ao enviar evento Meta Ads (PIX):', metaData.error, metaData.details);
              }
            } catch (metaError) {
              console.error('Erro na requisição Meta Ads (PIX):', metaError);
            }
          }

          // Integração com Google Ads
          if (typeof gtag === 'function' && GOOGLE_SNIPPET_CODE && GOOGLE_LABEL) {
            gtag('event', 'conversion', {
              'send_to': `${GOOGLE_SNIPPET_CODE}/${GOOGLE_LABEL}`,
              'value': PRODUCT_VALUE,
              'currency': 'BRL'
            });
            console.log('Evento Google Ads enviado com sucesso (PIX).');
          }

          window.location.replace("<?php echo htmlspecialchars($obrigadoUrl); ?>");
          //alert("Pagamento confirmado!");
        } else if (status === "WAITING_FOR_APPROVAL") {
          console.log("Aguardando aprovação...");
        }
      } catch (error) {
        console.error("Erro na verificação do pagamento:", error);
      }
    }


  </script>

  <script>
    // Função para formatar o campo CPF no formato XXX.XXX.XXX-XX
    document.getElementById('cpf').addEventListener('input', function (e) {
      let value = e.target.value.replace(/\D/g, ''); // Remove tudo que não for número
      if (value.length <= 11) {
        value = value
          .replace(/(\d{3})(\d)/, '$1.$2') // Coloca o primeiro ponto
          .replace(/(\d{3})(\d)/, '$1.$2') // Coloca o segundo ponto
          .replace(/(\d{3})(\d{1,2})$/, '$1-$2'); // Coloca o traço
      }
      e.target.value = value.slice(0, 14); // Limita a 14 caracteres
    });
  </script>

  <script>
    // Função para formatar o CPF no formato XXX.XXX.XXX-XX e limitar os caracteres
    document.getElementById('document').addEventListener('input', function (e) {
      let value = e.target.value.replace(/\D/g, ''); // Remove tudo que não for número
      if (value.length > 11) {
        value = value.slice(0, 11); // Limita a 11 números
      }
      value = value
        .replace(/(\d{3})(\d)/, '$1.$2') // Coloca o primeiro ponto
        .replace(/(\d{3})(\d)/, '$1.$2') // Coloca o segundo ponto
        .replace(/(\d{3})(\d{1,2})$/, '$1-$2'); // Coloca o traço
      e.target.value = value;
    });
  </script>

  <script>

    // Função para formatar o telefone no formato (XX)XXXXX-XXXX e limitar os caracteres
    document.getElementsByName('telefone')[0].addEventListener('input', function (e) {
      let value = e.target.value.replace(/\D/g, ''); // Remove tudo que não for número
      if (value.length > 11) {
        value = value.slice(0, 11); // Limita a 11 números
      }
      value = value
        .replace(/(\d{2})(\d)/, '($1) $2') // Coloca os parênteses no DDD
        .replace(/(\d{5})(\d)/, '$1-$2'); // Coloca o traço após os primeiros 5 dígitos
      e.target.value = value;
    });

  </script>

  <script>
    // Função para atualizar informações de parcelamento
    function updateInstallmentInfo() {
      const installmentCount = parseInt(document.getElementById('installmentCount').value);
      const totalValue = parseFloat(document.getElementById('valuedeposit').value.replace(',', '.'));
      const installmentInfo = document.getElementById('installmentInfo');
      const installmentDetails = document.getElementById('installmentDetails');
      const submitButton = document.getElementById('submitButton');
      
      if (installmentCount > 1) {
        const installmentValue = totalValue / installmentCount;
        
        // Validação de valor mínimo por parcela (R$ 5,00)
        if (installmentValue < 5.00) {
          alert(`Valor por parcela: R$ ${installmentValue.toFixed(2).replace('.', ',')} - Mínimo: R$ 5,00`);
          // Volta para 1x (à vista)
          document.getElementById('installmentCount').value = '1';
          installmentInfo.style.display = 'none';
          submitButton.querySelector('.inherit').textContent = 'Comprar e receber agora';
          return;
        }
        
        const formattedValue = installmentValue.toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        });
        const formattedTotal = totalValue.toLocaleString('pt-BR', {
          style: 'currency',
          currency: 'BRL'
        });
        
        installmentDetails.innerHTML = `
          <strong>Parcelamento:</strong> ${installmentCount}x de ${formattedValue}<br>
          <strong>Total:</strong> ${formattedTotal}
        `;
        installmentInfo.style.display = 'block';
        
        // Atualiza texto do botão
        submitButton.querySelector('.inherit').textContent = `Comprar em ${installmentCount}x de ${formattedValue}`;
      } else {
        installmentInfo.style.display = 'none';
        // Volta ao texto original do botão
        submitButton.querySelector('.inherit').textContent = 'Comprar e receber agora';
      }
    }

    // Tabs de seleção
    function selectPayment(tipo) {
      document.getElementById('btnPix').classList.remove('active');
      document.getElementById('btnCard').classList.remove('active');
      document.getElementById('pixOption').style.display = 'none';
      document.getElementById('cardOption').style.display = 'none';
      if (tipo === 'PIX') {
        document.getElementById('btnPix').classList.add('active');
        document.getElementById('pixOption').style.display = 'block';
        // Ao voltar para PIX, não faz nada especial aqui; a geração do QR controla a UI
      } else {
        document.getElementById('btnCard').classList.add('active');
        document.getElementById('cardOption').style.display = 'block';
        // Esconde o QR/instruções do PIX e reexibe o conteúdo principal ao selecionar Cartão
        document.querySelectorAll('.box1').forEach(function (element) {
          element.style.display = 'none';
        });
        document.querySelectorAll('.properties').forEach(function (element) {
          element.style.display = 'block';
        });
        // Interrompe o polling do PIX, caso esteja ativo
        if (window.pixStatusInterval) {
          clearInterval(window.pixStatusInterval);
          window.pixStatusInterval = null;
        }
        // Atualiza informações de parcelamento ao selecionar cartão
        updateInstallmentInfo();
      }
      window.tipoPagamentoSelecionado = tipo;
    }
    window.tipoPagamentoSelecionado = 'PIX'; // padrão

    // Função principal de envio
    async function enviarPagamento() {
      // Desabilita o botão de submit
      const submitButton = document.getElementById('submitButton');
      submitButton.disabled = true;
      submitButton.style.opacity = '0.6';
      submitButton.style.cursor = 'not-allowed';
      
      var tipo = window.tipoPagamentoSelecionado;
      var name = document.getElementById('name').value;
      var cpf = document.getElementById('document').value;
      var amount = document.getElementById('valuedeposit').value;
      var email = document.getElementsByName('yourEmail')[0].value;
      var apiUrl = `https://api.berapay.com.br/v1/adquirente/${adquirente}/processa_pagamento.php`;
      var user_id = document.getElementById('user_id').value;
      var payload = {
        name: name,
        cpf: cpf,
        amount: amount,
        tipoPagamento: tipo,
        email: email,
        user_id: user_id,
        productName: PRODUCT_NAME
      };
      
      // Adiciona informações de parcelamento se for cartão de crédito
      if (tipo === 'CREDIT_CARD') {
        var installmentCount = parseInt(document.getElementById('installmentCount').value);
        payload.installmentCount = installmentCount;
      }
      
      if (tipo === 'CREDIT_CARD') {
        // Pega dados do cartão
        var cardNumber = document.getElementById('cardNumber').value.replace(/\s/g, '');
        var cardName = document.getElementById('cardName').value;
        var telefone = document.getElementById('telefone').value;
        var cardExpiry = document.getElementById('cardExpiry').value;
        var cardCvv = document.getElementById('cardCvv').value;
        var cardCep = document.getElementById('cardCep').value;
        var numero_endereco = document.getElementById('numero_endereco').value;
        var endereco = document.getElementById('endereco').value;
        var cardCity = document.getElementById('cardCity').value;
        var cardState = document.getElementById('cardState').value;
        var [expMonth, expYear] = cardExpiry.split('/');
        payload.creditCard = {
          number: cardNumber,
          expiryMonth: expMonth,
          expiryYear: '20' + expYear,
          ccv: cardCvv
        };
        payload.creditCardHolderInfo = {
          name: cardName,
          email: email,
          cpfCnpj: cpf,
          postalCode: cardCep,
          addressNumber: numero_endereco,
          address: endereco,
          phone: telefone,
          city: cardCity,
          state: cardState
        };
      }
      document.getElementById('loadingSpinner').style.display = 'block';
      try {
        const response = await fetch(apiUrl, {
          method: 'POST',
          headers: { 'Content-Type': 'application/json' },
          body: JSON.stringify(payload)
        });
        const data = await response.json();
        document.getElementById('loadingSpinner').style.display = 'none';
        
        // Reabilita o botão de submit
        submitButton.disabled = false;
        submitButton.style.opacity = '1';
        submitButton.style.cursor = 'pointer';
        
        if (tipo === 'PIX') {
          if (data.paymentCode) {
            document.getElementById('qr-code-text').textContent = data.paymentCode;
            document.getElementById('qrcode').innerHTML = '';
            new QRCode(document.getElementById('qrcode'), {
              text: data.paymentCode,
              width: 256,
              height: 256
            });
            document.querySelectorAll('.properties').forEach(function (element) {
              element.style.display = 'none';
            });
            document.querySelectorAll('.box1').forEach(function (element) {
              element.style.display = 'block';
            });
            window.transactionId = data.idTransaction;
            if (window.pixStatusInterval) {
              clearInterval(window.pixStatusInterval);
            }
            window.pixStatusInterval = setInterval(checkPaymentStatus, 2000);
          } else {
            // Trata erro de valor mínimo vindo da adquirente exibindo (Erro: G-100)
            let userMsg = 'Erro ao gerar Pix.';
            try {
              // Verifica mensagens comuns do Asaas
              const desc = data?.asaas?.errors?.[0]?.description || '';
              const code = data?.asaas?.errors?.[0]?.code || '';
              const message = typeof data?.message === 'string' ? data.message : '';

              const minValueHints = [
                'valor da cobrança',
                'menor que',
                'mínimo',
                'nao pode ser menor',
                'não pode ser menor'
              ];

              const textBlob = `${desc} ${message} ${code}`.toLowerCase();
              const isMinValue = minValueHints.some(h => textBlob.includes(h));

              if (isMinValue) {
                userMsg = 'O valor informado é menor que o mínimo permitido (Erro: G-100)';
              } else if (message) {
                userMsg = `${message}`;
              }
            } catch (_) {}

            if (typeof showCustomAlert === 'function') {
              showCustomAlert(userMsg, 'error', 6000);
            } else {
              alert(userMsg);
            }
            console.error('PIX_ERROR_DETAILS', data);
          }
        } else if (tipo === 'CREDIT_CARD') {
          if (data.status === 'success') {
            // Integração com Meta Ads (Facebook Pixel)
            if (META_PIXEL_ID && META_ACCESS_TOKEN) {
              try {
                const metaResponse = await fetch('/integracoes/process_meta_conversion.php', {
                  method: 'POST',
                  headers: { 'Content-Type': 'application/json' },
                  body: JSON.stringify({
                    meta_pixel_id: META_PIXEL_ID,
                    meta_access_token: META_ACCESS_TOKEN,
                    value: PRODUCT_VALUE,
                    currency: 'BRL',
                    event_name: 'Purchase',
                    event_source_url: window.location.href,
                    user_email: USER_EMAIL,
                  })
                });
                const metaData = await metaResponse.json();
                if (metaData.success) {
                  console.log('Evento Meta Ads enviado com sucesso:', metaData.response);
                } else {
                  console.error('Erro ao enviar evento Meta Ads:', metaData.error, metaData.details);
                }
              } catch (metaError) {
                console.error('Erro na requisição Meta Ads:', metaError);
              }
            }

            // Integração com Google Ads
            if (typeof gtag === 'function' && GOOGLE_SNIPPET_CODE && GOOGLE_LABEL) {
              gtag('event', 'conversion', {
                'send_to': `${GOOGLE_SNIPPET_CODE}/${GOOGLE_LABEL}`,
                'value': PRODUCT_VALUE,
                'currency': 'BRL'
              });
              console.log('Evento Google Ads enviado com sucesso.');
            }

            showCustomAlert('Pagamento com cartão aprovado!', 'success', 3000);
            setTimeout(() => {
              window.location.replace("<?php echo htmlspecialchars($obrigadoUrl); ?>");
            }, 2000);
          } else {
            // Trata erros específicos da API
            let errorMessage = 'Erro no pagamento';
            
            if (data.message) {
              errorMessage = data.message;
            }
        // console.log(data.asaas_error);
            // Se há erros específicos no array errors, usa o primeiro
            if (data.errors && data.errors.length > 0) {
              const firstError = data.errors[0];
              if (firstError.description) {
                errorMessage = firstError.description;
              } else if (firstError.message) {
                errorMessage = firstError.message;
              }
            }
            
            showCustomAlert(data.asaas_error, 'error', 5000);
          }
        }
      } catch (error) {
        document.getElementById('loadingSpinner').style.display = 'none';
        
        // Reabilita o botão de submit em caso de erro
        submitButton.disabled = false;
        submitButton.style.opacity = '1';
        submitButton.style.cursor = 'pointer';
        
        showCustomAlert('Erro na solicitação: ' + error.message, 'error', 5000);
      }
    }
  </script>





  <script>
    document.getElementById('copy-button-pix').addEventListener('click', function (event) {
      event.preventDefault();
      // Seleciona o texto do div
      var textToCopy = document.getElementById('qr-code-text').innerText;

      // Cria um elemento de input temporário para usar o comando de copiar
      var tempInput = document.createElement('input');
      tempInput.value = textToCopy;
      document.body.appendChild(tempInput);

      // Seleciona o texto no input e copia
      tempInput.select();
      document.execCommand('copy');

      // Remove o input temporário da página
      document.body.removeChild(tempInput);

      // Alerta customizado de sucesso
      showCustomAlert('Código Pix copiado com sucesso!', 'success');
    });
  
    // Função para buscar cidade e estado pelo CEP usando ViaCEP
    document.getElementById('cardCep').addEventListener('blur', function () {
      var cep = this.value.replace(/\D/g, '');
      if (cep.length === 8) {
        fetch('https://viacep.com.br/ws/' + cep + '/json/')
          .then(response => response.json())
          .then(data => {
            if (!data.erro) {
              document.getElementById('cardCity').value = data.localidade || '';
              document.getElementById('cardState').value = data.uf || '';
            } else {
              document.getElementById('cardCity').value = '';
              document.getElementById('cardState').value = '';
            }
          })
          .catch(() => {
            document.getElementById('cardCity').value = '';
            document.getElementById('cardState').value = '';
          });
      } else {
        document.getElementById('cardCity').value = '';
        document.getElementById('cardState').value = '';
      }
    });
  </script>

</body>

</html>