<?php
// Página de Obrigado padrão do Checkout v1
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Obrigado pela sua compra</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --primary: #16a34a;
      --primary-dark: #15803d;
      --text: #1f2937;
      --muted: #6b7280;
      --bg: #f7f8fb;
      --card: #ffffff;
    }
    * { box-sizing: border-box; }
    body {
      margin: 0;
      font-family: 'Inter', system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
      background: var(--bg);
      color: var(--text);
    }
    .container {
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 24px;
    }
    .card {
      background: var(--card);
      width: 100%;
      max-width: 720px;
      border-radius: 16px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.06);
      padding: 40px 28px;
      text-align: center;
    }
    .icon-wrap {
      width: 88px;
      height: 88px;
      margin: 0 auto 16px;
      border-radius: 999px;
      background: rgba(22,163,74,0.10);
      display: grid;
      place-items: center;
    }
    .icon {
      width: 44px;
      height: 44px;
      color: var(--primary);
    }
    h1 {
      font-size: 28px;
      line-height: 1.2;
      margin: 8px 0 8px;
    }
    p {
      margin: 0;
      color: var(--muted);
      font-size: 16px;
    }
    .actions { margin-top: 28px; display: flex; gap: 12px; justify-content: center; flex-wrap: wrap; }
    .btn {
      appearance: none;
      border: 0;
      background: var(--primary);
      color: #fff;
      padding: 12px 18px;
      border-radius: 10px;
      font-weight: 600;
      cursor: pointer;
      transition: background .2s ease, transform .06s ease;
      text-decoration: none;
      display: inline-block;
    }
    .btn:hover { background: var(--primary-dark); }
    .btn:active { transform: translateY(1px); }
    .btn-outline {
      background: transparent;
      color: var(--primary);
      border: 1.5px solid rgba(22,163,74,0.35);
    }
    .note {
      margin-top: 16px;
      font-size: 13px;
      color: var(--muted);
    }
    .divider {
      height: 1px; background: #eef2f7; margin: 24px 0;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="card">
      <div class="icon-wrap" aria-hidden="true">
        <svg class="icon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
          <path d="M9 12.75l2 2 4-4" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/>
          <path d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="1.2"/>
        </svg>
      </div>
      <h1>Pagamento aprovado</h1>
      <p>Obrigado pela sua compra! Seu pagamento foi confirmado com sucesso.</p>
      <div class="divider"></div>
      <p>Você receberá um e-mail com os detalhes do pedido e instruções, se necessário.</p>
      <div class="actions">
        <a class="btn" href="/" rel="nofollow">Ir para a página inicial</a>
      </div>
      <div class="note">Se precisar de ajuda, entre em contato com o suporte informando seu e-mail de compra.</div>
    </div>
  </div>
</body>
</html>

