<?php
include '../conectarbanco.php';

$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);

if ($conn->connect_error) {
    die(json_encode(['success' => false, 'message' => 'Erro na conexão: ' . $conn->connect_error]));
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $url = isset($_POST['url']) ? trim($_POST['url']) : '';
    $secretKey = isset($_POST['secret_key']) ? trim($_POST['secret_key']) : '';
    $taxaCashIn = isset($_POST['taxa_cash_in']) ? (float)$_POST['taxa_cash_in'] : 0;
    $taxaCashOut = isset($_POST['taxa_cash_out']) ? (float)$_POST['taxa_cash_out'] : 0;

    $sql = "UPDATE ad_asaas SET url = ?, secret_key = ?, taxa_cash_in = ?, taxa_cash_out = ? LIMIT 1";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        echo json_encode(['success' => false, 'message' => 'Erro ao preparar: ' . $conn->error]);
        exit;
    }

    $stmt->bind_param('ssdd', $url, $secretKey, $taxaCashIn, $taxaCashOut);

    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erro ao executar: ' . $stmt->error]);
    }

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Método inválido']);
}

$conn->close();
?>


