<?php
require_once __DIR__ . '/../adquirente/asaas/asaas_functions.php';
include_once __DIR__ . '/../../../conectarbanco.php';

header('Content-Type: application/json');










// // Salva todos os dados recebidos via POST em um arquivo
// $logDir = __DIR__ . '/logs'; // cria uma pasta "logs" no mesmo diretório
// if (!is_dir($logDir)) {
//     mkdir($logDir, 0755, true);
// }
// $logFile = $logDir . '/post_log_' . date('Y-m-d') . '.txt'; // arquivo com a data de hoje

// // Criação do conteúdo do log
// $logContent = "Data/Hora: " . date('Y-m-d H:i:s') . "\n";

// // Adiciona a URL completa
// $logContent .= "URL completa: " . $_SERVER['REQUEST_URI'] . "\n";

// // Adiciona todos os parâmetros GET
// $logContent .= "GET:\n" . print_r($_GET, true) . "\n";

// // Adiciona todos os parâmetros POST
// $logContent .= "POST:\n" . print_r($_POST, true) . "\n";

// // Adiciona o conteúdo da requisição (se estiver disponível)

//     $logContent .= "REQUEST:\n" . print_r($_REQUEST, true) . "\n";
 
 
//  $logContent .= " var REQUEST:\n" . var_dump($_REQUEST, true) . "\n";

// // Adiciona uma linha separadora para melhorar a legibilidade no log
// $logContent .= str_repeat('-', 80) . "\n";

// // Escreve o conteúdo no arquivo de log
// file_put_contents($logFile, $logContent, FILE_APPEND);


















// Recebe o ID do pedido
$id = $_REQUEST['id'] ?? ($_REQUEST['id'] ?? null);
if (!$id) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'ID do pedido não informado']);
    exit;
}

// Conexão com o banco
$conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Erro ao conectar no banco']);
    exit;
}

// Busca o pedido pelo ID e adquirente
$stmt = $conn->prepare("SELECT id, idtransaction, status FROM solicitacoes WHERE idtransaction = ? AND adquirente_ref = 'asaas' LIMIT 1");
$stmt->bind_param("s", $id);
$stmt->execute();
$res = $stmt->get_result();

// echo "SELECT id, idtransaction, status FROM solicitacoes WHERE idtransaction = {$id} AND adquirente_ref = 'asaas' LIMIT 1";

if ($res && $res->num_rows > 0) {
    $pedido = $res->fetch_assoc();
    $idtransaction = $pedido['idtransaction'];
    $status_banco = $pedido['status'];
    $id_pedido = $pedido['id'];

    // Verifica se existe ID da transação para consultar na Asaas
    if (!$idtransaction) {
        echo json_encode(['status' => 'error', 'message' => 'ID da transação não encontrado para este pedido.']);
        exit;
    }

    // Consulta a transação no Asaas
$asaas = asaasRequest("payments/{$id}", 'GET');


 

    if (!isset($asaas['status'])) {
        echo json_encode(['status' => 'error', 'message' => 'Erro ao consultar status no Asaas', 'asaas_response' => $asaas]);
        exit;
    }

    $status_asaas = $asaas['status'];

    switch($status_asaas) {
        case 'PENDING':
            $status_asaas = "WAITING_FOR_APPROVAL";
            break;
      case 'CONFIRMED':
        case 'RECEIVED':
            $status_asaas = "PAID_OUT";
            break;
        default:
            echo "Status Desconhecido";
    }

    // exit;
    // Atualiza se o status estiver diferente
    if ($status_asaas != $status_banco) {
        // Se for transação de cartão de crédito e status for PAID_OUT, capturar estimatedCreditDate
        $saque_disponivel = null;
        if ($status_asaas === 'PAID_OUT' && isset($asaas['billingType']) && $asaas['billingType'] === 'CREDIT_CARD' && isset($asaas['estimatedCreditDate'])) {
            try {
                $dateTime = new DateTime($asaas['estimatedCreditDate']);
                $saque_disponivel = $dateTime->format('Y-m-d H:i:s');
            } catch (Exception $e) {
                error_log("Erro ao converter estimatedCreditDate: " . $e->getMessage());
            }
        }
        
        if ($saque_disponivel) {
            $stmtUpdate = $conn->prepare("UPDATE solicitacoes SET status = ?, saque_disponivel = ? WHERE id = ?");
            $stmtUpdate->bind_param("ssi", $status_asaas, $saque_disponivel, $id_pedido);
        } else {
            $stmtUpdate = $conn->prepare("UPDATE solicitacoes SET status = ? WHERE id = ?");
            $stmtUpdate->bind_param("si", $status_asaas, $id_pedido);
        }
        
        $stmtUpdate->execute();
        $stmtUpdate->close();



//  print_r($status_asaas !== $status_banco);
 
 
        echo json_encode([
            'status' => 'updated',
            'id' => $id,
            'idtransaction' => $idtransaction,
            'old_status' => $status_banco,
            'new_status' => $status_asaas
        ]);
    } else {
        echo json_encode([
            'status' => 'no_change',
            'id' => $id,
            'idtransaction' => $idtransaction,
            'current_status' => $status_banco
        ]);
    }

} else {
    echo json_encode(['status' => 'empty', 'message' => 'Pedido não encontrado']);
}

$stmt->close();
$conn->close();
