<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "=== TESTE SIMPLES DA API ===\n\n";

// 1. Testar se o arquivo config.php carrega
echo "1. Testando config.php:\n";
try {
    require_once 'config.php';
    echo "   ✅ config.php carregado com sucesso\n";
    echo "   Versão: " . (defined('API_VERSION') ? API_VERSION : 'N/A') . "\n";
} catch (Exception $e) {
    echo "   ❌ Erro ao carregar config.php: " . $e->getMessage() . "\n";
} catch (Error $e) {
    echo "   ❌ Erro fatal ao carregar config.php: " . $e->getMessage() . "\n";
}

// 2. Testar se o arquivo conectarbanco.php carrega
echo "\n2. Testando conectarbanco.php:\n";
try {
    require_once 'conectarbanco.php';
    echo "   ✅ conectarbanco.php carregado com sucesso\n";
    echo "   Configurações: " . json_encode($config) . "\n";
} catch (Exception $e) {
    echo "   ❌ Erro ao carregar conectarbanco.php: " . $e->getMessage() . "\n";
} catch (Error $e) {
    echo "   ❌ Erro fatal ao carregar conectarbanco.php: " . $e->getMessage() . "\n";
}

// 3. Testar conexão com banco
echo "\n3. Testando conexão com banco:\n";
try {
    $conn = new mysqli('localhost', $config['db_user'], $config['db_pass'], $config['db_name']);
    
    if ($conn->connect_error) {
        echo "   ❌ Erro na conexão: " . $conn->connect_error . "\n";
    } else {
        echo "   ✅ Conexão estabelecida com sucesso\n";
        
        // Verificar tabela ad_asaas
        $result = $conn->query("SELECT * FROM ad_asaas WHERE id = 1");
        if ($result && $result->num_rows > 0) {
            $asaas = $result->fetch_assoc();
            echo "   ✅ Configuração do Asaas encontrada\n";
            echo "   URL: " . ($asaas['url'] ?? 'N/A') . "\n";
            echo "   Secret Key: " . (strlen($asaas['secret_key'] ?? '') > 10 ? 'Configurada' : 'N/A') . "\n";
        } else {
            echo "   ❌ Configuração do Asaas NÃO encontrada\n";
        }
        
        $conn->close();
    }
} catch (Exception $e) {
    echo "   ❌ Exceção na conexão: " . $e->getMessage() . "\n";
} catch (Error $e) {
    echo "   ❌ Erro fatal na conexão: " . $e->getMessage() . "\n";
}

// 4. Testar se as funções estão disponíveis
echo "\n4. Testando funções:\n";
$functions = ['getConfig', 'getErrorMessage', 'generateRandomString'];
foreach ($functions as $func) {
    if (function_exists($func)) {
        echo "   ✅ $func() está disponível\n";
    } else {
        echo "   ❌ $func() NÃO está disponível\n";
    }
}

echo "\n=== FIM DO TESTE ===\n";
echo "Data/Hora: " . date('Y-m-d H:i:s') . "\n";
?>
