<?php
/**
 * Verificação Rápida do Plugin PIX Gateway
 * Acesse este arquivo diretamente no navegador para verificar o status
 */

// Verificar se estamos no WordPress
if (!defined('ABSPATH')) {
    echo "<h2>❌ Plugin não está sendo executado no WordPress</h2>";
    echo "<p>Este arquivo deve ser acessado através do WordPress.</p>";
    echo "<p>Verifique se o plugin está ativo e se a estrutura está correta.</p>";
    exit;
}

echo "<h1>🔍 Verificação do Plugin PIX Gateway</h1>";
echo "<hr>";

// Verificar versão do WordPress
$wp_version = get_bloginfo('version');
echo "<h3>📊 Informações do Sistema</h3>";
echo "<p><strong>WordPress:</strong> {$wp_version}</p>";
echo "<p><strong>PHP:</strong> " . PHP_VERSION . "</p>";
echo "<p><strong>Plugin Path:</strong> " . WC_PIX_GATEWAY_PLUGIN_PATH . "</p>";
echo "<p><strong>Plugin URL:</strong> " . WC_PIX_GATEWAY_PLUGIN_URL . "</p>";

// Verificar se WooCommerce está ativo
if (class_exists('WooCommerce')) {
    $wc_version = WC()->version;
    echo "<p><strong>WooCommerce:</strong> {$wc_version} ✅</p>";
} else {
    echo "<p><strong>WooCommerce:</strong> ❌ NÃO ATIVO</p>";
}

echo "<hr>";

// Verificar arquivos do plugin
echo "<h3>📁 Verificação de Arquivos</h3>";

$files_to_check = array(
    'woocommerce-pix-gateway.php' => 'Arquivo Principal',
    'includes/class-wc-pix-gateway.php' => 'Classe do Gateway',
    'admin/admin-page.php' => 'Página Administrativa',
    'config.php' => 'Configurações',
    'assets/css/frontend.css' => 'CSS Frontend',
    'assets/js/frontend.js' => 'JavaScript Frontend'
);

foreach ($files_to_check as $file => $description) {
    $full_path = WC_PIX_GATEWAY_PLUGIN_PATH . $file;
    if (file_exists($full_path)) {
        echo "<p><strong>{$description}:</strong> ✅ {$file}</p>";
    } else {
        echo "<p><strong>{$description}:</strong> ❌ {$file} (NÃO ENCONTRADO)</p>";
    }
}

echo "<hr>";

// Verificar configurações
echo "<h3>⚙️ Configurações do Plugin</h3>";

$options = array(
    'wc_pix_gateway_api_key' => 'API Key',
    'wc_pix_gateway_api_url' => 'API URL',
    'wc_pix_gateway_sandbox' => 'Modo Sandbox',
    'wc_pix_gateway_debug' => 'Modo Debug',
    'wc_pix_gateway_expiration_time' => 'Tempo de Expiração'
);

foreach ($options as $option => $description) {
    $value = get_option($option, 'NÃO DEFINIDO');
    echo "<p><strong>{$description}:</strong> {$value}</p>";
}

echo "<hr>";

// Verificar hooks do WooCommerce
echo "<h3>🔗 Hooks do WooCommerce</h3>";

if (has_filter('woocommerce_payment_gateways')) {
    echo "<p><strong>Filtro de Gateways:</strong> ✅ Ativo</p>";
} else {
    echo "<p><strong>Filtro de Gateways:</strong> ❌ Não ativo</p>";
}

// Verificar se o gateway está registrado
$gateways = apply_filters('woocommerce_payment_gateways', array());
$pix_gateway_found = false;

foreach ($gateways as $gateway) {
    if (strpos($gateway, 'PIX') !== false || strpos($gateway, 'pix') !== false) {
        $pix_gateway_found = true;
        break;
    }
}

if ($pix_gateway_found) {
    echo "<p><strong>Gateway PIX:</strong> ✅ Registrado</p>";
} else {
    echo "<p><strong>Gateway PIX:</strong> ❌ NÃO REGISTRADO</p>";
}

echo "<hr>";

// Verificar permissões
echo "<h3>🔐 Permissões</h3>";

if (current_user_can('manage_woocommerce')) {
    echo "<p><strong>Usuário Atual:</strong> ✅ Pode gerenciar WooCommerce</p>";
} else {
    echo "<p><strong>Usuário Atual:</strong> ❌ NÃO pode gerenciar WooCommerce</p>";
}

echo "<hr>";

// Verificar se há erros no log
echo "<h3>📝 Logs de Erro</h3>";

if (function_exists('wc_get_logger')) {
    $logger = wc_get_logger();
    $logs = $logger->get_log_files();
    
    if (!empty($logs)) {
        echo "<p><strong>Logs Disponíveis:</strong></p>";
        echo "<ul>";
        foreach ($logs as $log_file => $log_path) {
            if (strpos($log_file, 'pix') !== false || strpos($log_file, 'gateway') !== false) {
                echo "<li>📄 {$log_file}</li>";
            }
        }
        echo "</ul>";
    } else {
        echo "<p>Nenhum log encontrado.</p>";
    }
} else {
    echo "<p>Logger do WooCommerce não disponível.</p>";
}

echo "<hr>";

// Recomendações
echo "<h3>💡 Recomendações</h3>";

if (!class_exists('WooCommerce')) {
    echo "<p>❌ <strong>ATIVE O WOOCOMMERCE</strong> antes de usar este plugin.</p>";
}

if (!$pix_gateway_found) {
    echo "<p>❌ <strong>REATIVE O PLUGIN</strong> para registrar o gateway.</p>";
}

if (get_option('wc_pix_gateway_api_key') === 'NÃO DEFINIDO') {
    echo "<p>⚠️ <strong>CONFIGURE A API KEY</strong> nas configurações do plugin.</p>";
}

echo "<hr>";

// Links úteis
echo "<h3>🔗 Links Úteis</h3>";
echo "<p><a href='" . admin_url('admin.php?page=wc-pix-gateway-settings') . "'>⚙️ Configurações do Plugin</a></p>";
echo "<p><a href='" . admin_url('admin.php?page=wc-settings&tab=checkout') . "'>💳 Configurações de Pagamento</a></p>";
echo "<p><a href='" . admin_url('plugins.php') . "'>📦 Gerenciar Plugins</a></p>";

echo "<hr>";
echo "<p><em>Verificação concluída em: " . date('d/m/Y H:i:s') . "</em></p>";
?>
