<?php
/**
 * Arquivo de configuração do Plugin WooCommerce PIX Gateway
 * 
 * Este arquivo contém todas as constantes e configurações padrão do plugin
 */

// Prevenir acesso direto
if (!defined('ABSPATH')) {
    exit;
}

// ============================================================================
// CONFIGURAÇÕES DO PLUGIN
// ============================================================================

// Informações do plugin
define('WC_PIX_GATEWAY_PLUGIN_NAME', 'WooCommerce PIX Gateway');
define('WC_PIX_GATEWAY_PLUGIN_VERSION', '1.0.0');
define('WC_PIX_GATEWAY_PLUGIN_URI', 'https://gateway.stackcode.com.br');
define('WC_PIX_GATEWAY_PLUGIN_AUTHOR', 'Seu Nome');
define('WC_PIX_GATEWAY_PLUGIN_AUTHOR_URI', 'https://seusite.com');
define('WC_PIX_GATEWAY_PLUGIN_DESCRIPTION', 'Gateway de pagamento PIX para WooCommerce integrado com Asaas');

// Requisitos mínimos
define('WC_PIX_GATEWAY_WP_MIN_VERSION', '5.0');
define('WC_PIX_GATEWAY_WC_MIN_VERSION', '5.0');
define('WC_PIX_GATEWAY_PHP_MIN_VERSION', '7.4');

// ============================================================================
// CONFIGURAÇÕES DA API
// ============================================================================

// URLs da API
define('WC_PIX_GATEWAY_API_BASE_URL', 'https://gateway.stackcode.com.br/api.seusite/v1/gateway/');
define('WC_PIX_GATEWAY_API_CREATE_PAYMENT', 'criar-pagamento.php');
define('WC_PIX_GATEWAY_API_CHECK_STATUS', 'consultar-status.php');

// Endpoints completos
define('WC_PIX_GATEWAY_API_CREATE_PAYMENT_URL', WC_PIX_GATEWAY_API_BASE_URL . WC_PIX_GATEWAY_API_CREATE_PAYMENT);
define('WC_PIX_GATEWAY_API_CHECK_STATUS_URL', WC_PIX_GATEWAY_API_BASE_URL . WC_PIX_GATEWAY_API_CHECK_STATUS);

// Timeouts e configurações de conexão
define('WC_PIX_GATEWAY_API_TIMEOUT', 30);
define('WC_PIX_GATEWAY_API_CONNECT_TIMEOUT', 10);
define('WC_PIX_GATEWAY_API_RETRY_ATTEMPTS', 3);

// ============================================================================
// CONFIGURAÇÕES DO WOOCOMMERCE
// ============================================================================

// ID do gateway
define('WC_PIX_GATEWAY_ID', 'pix_gateway');
define('WC_PIX_GATEWAY_TITLE', 'Pagamento PIX');
define('WC_PIX_GATEWAY_DESCRIPTION', 'Pague com PIX de forma rápida e segura.');

// Status dos pedidos
define('WC_PIX_GATEWAY_ORDER_STATUS_PENDING', 'pending');
define('WC_PIX_GATEWAY_ORDER_STATUS_COMPLETED', 'completed');
define('WC_PIX_GATEWAY_ORDER_STATUS_FAILED', 'failed');
define('WC_PIX_GATEWAY_ORDER_STATUS_CANCELLED', 'cancelled');
define('WC_PIX_GATEWAY_ORDER_STATUS_REFUNDED', 'refunded');

// Meta keys para armazenar dados do pagamento
define('WC_PIX_GATEWAY_META_PAYMENT_ID', '_pix_payment_id');
define('WC_PIX_GATEWAY_META_EXTERNAL_REFERENCE', '_pix_external_reference');
define('WC_PIX_GATEWAY_META_PAYMENT_CODE', '_pix_payment_code');
define('WC_PIX_GATEWAY_META_PAYMENT_CODE_BASE64', '_pix_payment_code_base64');
define('WC_PIX_GATEWAY_META_EXPIRES_AT', '_pix_expires_at');
define('WC_PIX_GATEWAY_META_PIX_KEY', '_pix_pix_key');
define('WC_PIX_GATEWAY_META_ASAAS_STATUS', '_pix_asaas_status');

// ============================================================================
// CONFIGURAÇÕES DE PAGAMENTO
// ============================================================================

// Tempo de expiração padrão (em minutos)
define('WC_PIX_GATEWAY_DEFAULT_EXPIRATION_TIME', 30);
define('WC_PIX_GATEWAY_MIN_EXPIRATION_TIME', 5);
define('WC_PIX_GATEWAY_MAX_EXPIRATION_TIME', 1440); // 24 horas

// Valores mínimos e máximos
define('WC_PIX_GATEWAY_MIN_AMOUNT', 0.01);
define('WC_PIX_GATEWAY_MAX_AMOUNT', 999999.99);

// ============================================================================
// CONFIGURAÇÕES DE WEBHOOK
// ============================================================================

// URL do webhook
define('WC_PIX_GATEWAY_WEBHOOK_URL', '/wc-api/wc_pix_gateway');

// Status de pagamento do gateway
define('WC_PIX_GATEWAY_STATUS_WAITING', 'WAITING_FOR_APPROVAL');
define('WC_PIX_GATEWAY_STATUS_PAID', 'PAID_OUT');
define('WC_PIX_GATEWAY_STATUS_OVERDUE', 'OVERDUE');
define('WC_PIX_GATEWAY_STATUS_CANCELLED', 'CANCELLED');
define('WC_PIX_GATEWAY_STATUS_REFUNDED', 'REFUNDED');

// ============================================================================
// CONFIGURAÇÕES DE DEBUG E LOG
// ============================================================================

// Logs
define('WC_PIX_GATEWAY_LOG_SOURCE', 'pix_gateway');
define('WC_PIX_GATEWAY_LOG_LEVEL_INFO', 'info');
define('WC_PIX_GATEWAY_LOG_LEVEL_ERROR', 'error');
define('WC_PIX_GATEWAY_LOG_LEVEL_DEBUG', 'debug');

// ============================================================================
// CONFIGURAÇÕES DE INTERFACE
// ============================================================================

// Tamanhos e dimensões
define('WC_PIX_GATEWAY_QR_CODE_SIZE', 250);
define('WC_PIX_GATEWAY_QR_CODE_BORDER', 8);
define('WC_PIX_GATEWAY_QR_CODE_CORRECTION_LEVEL', 'H');

// Intervalos de verificação automática (em milissegundos)
define('WC_PIX_GATEWAY_AUTO_CHECK_INTERVAL', 30000); // 30 segundos
define('WC_PIX_GATEWAY_COUNTDOWN_WARNING_TIME', 300000); // 5 minutos

// ============================================================================
// CONFIGURAÇÕES DE SEGURANÇA
// ============================================================================

// Nonces
define('WC_PIX_GATEWAY_NONCE_ACTION', 'wc_pix_gateway_nonce');
define('WC_PIX_GATEWAY_NONCE_ACTION_SETTINGS', 'wc_pix_gateway_settings');
define('WC_PIX_GATEWAY_NONCE_ACTION_TEST', 'wc_pix_gateway_test');

// Capacidades necessárias
define('WC_PIX_GATEWAY_CAPABILITY', 'manage_woocommerce');

// ============================================================================
// CONFIGURAÇÕES DE IDIOMA
// ============================================================================

// Text domain
define('WC_PIX_GATEWAY_TEXT_DOMAIN', 'woocommerce-pix-gateway');
define('WC_PIX_GATEWAY_LANGUAGES_PATH', '/languages');

// ============================================================================
// CONFIGURAÇÕES DE ARQUIVOS
// ============================================================================

// Diretórios
define('WC_PIX_GATEWAY_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('WC_PIX_GATEWAY_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WC_PIX_GATEWAY_INCLUDES_DIR', WC_PIX_GATEWAY_PLUGIN_DIR . 'includes/');
define('WC_PIX_GATEWAY_ADMIN_DIR', WC_PIX_GATEWAY_PLUGIN_DIR . 'admin/');
define('WC_PIX_GATEWAY_TEMPLATES_DIR', WC_PIX_GATEWAY_PLUGIN_DIR . 'templates/');
define('WC_PIX_GATEWAY_ASSETS_DIR', WC_PIX_GATEWAY_PLUGIN_DIR . 'assets/');
define('WC_PIX_GATEWAY_CSS_DIR', WC_PIX_GATEWAY_ASSETS_DIR . 'css/');
define('WC_PIX_GATEWAY_JS_DIR', WC_PIX_GATEWAY_ASSETS_DIR . 'js/');

// ============================================================================
// CONFIGURAÇÕES DE AJAX
// ============================================================================

// Ações AJAX
define('WC_PIX_GATEWAY_AJAX_CREATE_PAYMENT', 'wc_pix_gateway_create_payment');
define('WC_PIX_GATEWAY_AJAX_CHECK_STATUS', 'wc_pix_gateway_check_status');

// ============================================================================
// CONFIGURAÇÕES DE NOTIFICAÇÕES
// ============================================================================

// Mensagens de sucesso
define('WC_PIX_GATEWAY_MSG_PAYMENT_CREATED', 'Pagamento PIX criado com sucesso!');
define('WC_PIX_GATEWAY_MSG_PAYMENT_CONFIRMED', 'Pagamento PIX confirmado!');
define('WC_PIX_GATEWAY_MSG_CODE_COPIED', 'Código PIX copiado com sucesso!');

// Mensagens de erro
define('WC_PIX_GATEWAY_MSG_API_ERROR', 'Erro na comunicação com o gateway.');
define('WC_PIX_GATEWAY_MSG_INVALID_API_KEY', 'API Key inválida ou inativa.');
define('WC_PIX_GATEWAY_MSG_PAYMENT_FAILED', 'Erro ao processar pagamento PIX.');

// ============================================================================
// CONFIGURAÇÕES DE VALIDAÇÃO
// ============================================================================

// Padrões de validação
define('WC_PIX_GATEWAY_CPF_PATTERN', '/^\d{11}$/');
define('WC_PIX_GATEWAY_CNPJ_PATTERN', '/^\d{14}$/');
define('WC_PIX_GATEWAY_PHONE_PATTERN', '/^\d{10,11}$/');
define('WC_PIX_GATEWAY_EMAIL_PATTERN', '/^[^\s@]+@[^\s@]+\.[^\s@]+$/');

// ============================================================================
// CONFIGURAÇÕES DE CACHE
// ============================================================================

// Tempo de cache para consultas de status (em segundos)
define('WC_PIX_GATEWAY_STATUS_CACHE_TIME', 60); // 1 minuto

// ============================================================================
// CONFIGURAÇÕES DE SANDBOX
// ============================================================================

// URLs de sandbox (se disponíveis)
define('WC_PIX_GATEWAY_SANDBOX_API_BASE_URL', 'https://sandbox.gateway.stackcode.com.br/api.seusite/v1/gateway/');

// ============================================================================
// FUNÇÕES AUXILIARES
// ============================================================================

/**
 * Verificar se o plugin está em modo de desenvolvimento
 */
function wc_pix_gateway_is_dev_mode() {
    return defined('WP_DEBUG') && WP_DEBUG;
}

/**
 * Verificar se o plugin está em modo sandbox
 */
function wc_pix_gateway_is_sandbox_mode() {
    return get_option('wc_pix_gateway_sandbox', 'yes') === 'yes';
}

/**
 * Obter URL da API baseada no modo atual
 */
function wc_pix_gateway_get_api_base_url() {
    if (wc_pix_gateway_is_sandbox_mode()) {
        return WC_PIX_GATEWAY_SANDBOX_API_BASE_URL;
    }
    return WC_PIX_GATEWAY_API_BASE_URL;
}

/**
 * Verificar se o debug está ativado
 */
function wc_pix_gateway_is_debug_enabled() {
    return get_option('wc_pix_gateway_debug', 'no') === 'yes';
}

/**
 * Obter versão mínima do WordPress
 */
function wc_pix_gateway_get_wp_min_version() {
    return WC_PIX_GATEWAY_WP_MIN_VERSION;
}

/**
 * Obter versão mínima do WooCommerce
 */
function wc_pix_gateway_get_wc_min_version() {
    return WC_PIX_GATEWAY_WC_MIN_VERSION;
}

/**
 * Obter versão mínima do PHP
 */
function wc_pix_gateway_get_php_min_version() {
    return WC_PIX_GATEWAY_PHP_MIN_VERSION;
}
