<?php
require_once 'config.php';

header("Content-Type: text/plain; charset=utf-8");

echo "=== DIAGNÓSTICO COMPLETO DA API GATEWAY ===\n\n";

// 1. Verificar configurações básicas
echo "1. CONFIGURAÇÕES BÁSICAS:\n";
echo "   Ambiente: " . getConfig('ENVIRONMENT', 'N/A') . "\n";
echo "   Versão: " . getConfig('API_VERSION', 'N/A') . "\n";
echo "   Debug: " . (getConfig('DEBUG_MODE', false) ? 'Ativado' : 'Desativado') . "\n";
echo "   Timezone: " . date_default_timezone_get() . "\n\n";

// 2. Verificar conexão com banco de dados
echo "2. CONEXÃO COM BANCO DE DADOS:\n";
try {
    $conn = new mysqli('localhost', getConfig('DB_USER'), getConfig('DB_PASS'), getConfig('DB_NAME'));
    
    if ($conn->connect_error) {
        echo "   ❌ Erro na conexão: " . $conn->connect_error . "\n";
    } else {
        echo "   ✅ Conexão estabelecida com sucesso\n";
        echo "   Servidor: " . $conn->server_info . "\n";
        echo "   Versão: " . $conn->server_version . "\n";
        
        // Verificar tabelas essenciais
        $tables = ['users_key', 'adquirentes', 'ad_asaas', 'solicitacoes', 'users'];
        foreach ($tables as $table) {
            $result = $conn->query("SHOW TABLES LIKE '$table'");
            if ($result->num_rows > 0) {
                echo "   ✅ Tabela '$table' existe\n";
            } else {
                echo "   ❌ Tabela '$table' NÃO existe\n";
            }
        }
        
        // Verificar configuração do Asaas
        echo "\n   --- CONFIGURAÇÃO DO ASAAS ---\n";
        $result = $conn->query("SELECT * FROM ad_asaas WHERE id = 1");
        if ($result && $result->num_rows > 0) {
            $asaas = $result->fetch_assoc();
            echo "   ✅ Configuração encontrada\n";
            echo "   URL: " . ($asaas['url'] ?? 'N/A') . "\n";
            echo "   Secret Key: " . (strlen($asaas['secret_key'] ?? '') > 10 ? 'Configurada' : 'N/A') . "\n";
        } else {
            echo "   ❌ Configuração do Asaas NÃO encontrada\n";
        }
        
        // Verificar adquirentes ativos
        echo "\n   --- ADQUIRENTES ATIVOS ---\n";
        $result = $conn->query("SELECT * FROM adquirentes WHERE status = 1");
        if ($result && $result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                echo "   ✅ " . $row['adquirente'] . " (ID: " . $row['id'] . ")\n";
            }
        } else {
            echo "   ❌ Nenhum adquirente ativo encontrado\n";
        }
        
        // Verificar API keys
        echo "\n   --- API KEYS ---\n";
        $result = $conn->query("SELECT COUNT(*) as total FROM users_key WHERE status = 'ativo'");
        if ($result && $result->num_rows > 0) {
            $count = $result->fetch_assoc()['total'];
            echo "   ✅ $count API keys ativas encontradas\n";
        } else {
            echo "   ❌ Nenhuma API key ativa encontrada\n";
        }
        
        $conn->close();
    }
} catch (Exception $e) {
    echo "   ❌ Exceção: " . $e->getMessage() . "\n";
}

// 3. Verificar arquivos essenciais
echo "\n3. ARQUIVOS ESSENCIAIS:\n";
$files = [
    'config.php' => 'Configuração principal',
    '../adquirente/asaas/asaas_functions.php' => 'Funções do Asaas',
    'conectarbanco.php' => 'Conexão com banco',
    'criar-pagamento.php' => 'Endpoint de criação de pagamento'
];

foreach ($files as $file => $description) {
    if (file_exists($file)) {
        echo "   ✅ $file - $description\n";
    } else {
        echo "   ❌ $file - $description (NÃO ENCONTRADO)\n";
    }
}

// 4. Verificar funções PHP
echo "\n4. FUNÇÕES PHP:\n";
$functions = ['curl_init', 'json_encode', 'mysqli_connect', 'file_put_contents'];
foreach ($functions as $func) {
    if (function_exists($func)) {
        echo "   ✅ $func() disponível\n";
    } else {
        echo "   ❌ $func() NÃO disponível\n";
    }
}

// 5. Verificar extensões
echo "\n5. EXTENSÕES PHP:\n";
$extensions = ['curl', 'mysqli', 'json'];
foreach ($extensions as $ext) {
    if (extension_loaded($ext)) {
        echo "   ✅ Extensão $ext carregada\n";
    } else {
        echo "   ❌ Extensão $ext NÃO carregada\n";
    }
}

// 6. Verificar permissões de arquivo
echo "\n6. PERMISSÕES DE ARQUIVO:\n";
$logFile = getConfig('LOG_FILE', __DIR__ . '/logs/api.log');
$logDir = dirname($logFile);

if (is_dir($logDir)) {
    if (is_writable($logDir)) {
        echo "   ✅ Diretório de logs é gravável\n";
    } else {
        echo "   ❌ Diretório de logs NÃO é gravável\n";
    }
} else {
    echo "   ❌ Diretório de logs NÃO existe\n";
}

// 7. Teste de função asaasRequest
echo "\n7. TESTE DA FUNÇÃO ASAASREQUEST:\n";
if (file_exists('../adquirente/asaas/asaas_functions.php')) {
    require_once '../adquirente/asaas/asaas_functions.php';
    
    if (function_exists('asaasRequest')) {
        echo "   ✅ Função asaasRequest carregada\n";
        
        // Teste simples de requisição
        try {
            $response = asaasRequest('customers', 'GET');
            if (isset($response['error'])) {
                echo "   ⚠️  Teste de requisição retornou erro: " . $response['message'] . "\n";
            } else {
                echo "   ✅ Teste de requisição bem-sucedido\n";
            }
        } catch (Exception $e) {
            echo "   ❌ Exceção no teste: " . $e->getMessage() . "\n";
        }
    } else {
        echo "   ❌ Função asaasRequest NÃO encontrada\n";
    }
} else {
    echo "   ❌ Arquivo asaas_functions.php NÃO encontrado\n";
}

echo "\n=== FIM DO DIAGNÓSTICO ===\n";
echo "Data/Hora: " . date('Y-m-d H:i:s') . "\n";
?>
